/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.nameresolution.CAssoc;
import mb.nabl2.constraints.nameresolution.CDeclProperty;
import mb.nabl2.constraints.nameresolution.CResolve;
import mb.nabl2.constraints.nameresolution.INameResolutionConstraint;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.esop.IEsopNameResolution;
import mb.nabl2.scopegraph.esop.IEsopScopeGraph;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.scopegraph.terms.path.Paths;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.TypeException;
import mb.nabl2.solver.components.NameResolutionResult;
import mb.nabl2.solver.exceptions.CriticalEdgeDelayException;
import mb.nabl2.solver.exceptions.DelayException;
import mb.nabl2.solver.exceptions.InterruptedDelayException;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.util.collections.IProperties;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

public class NameResolutionComponent
extends ASolver {
    private final IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph;
    private final IEsopNameResolution<Scope, Label, Occurrence> nameResolution;
    private final IProperties.Transient<Occurrence, ITerm, ITerm> properties;

    public NameResolutionComponent(SolverCore core, IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph, IEsopNameResolution<Scope, Label, Occurrence> nameResolution, IProperties.Transient<Occurrence, ITerm, ITerm> initial) {
        super(core);
        this.scopeGraph = scopeGraph;
        this.nameResolution = nameResolution;
        this.properties = initial;
    }

    public SeedResult seed(NameResolutionResult solution, IMessageInfo message) throws InterruptedException {
        HashSet constraints = Sets.newHashSet();
        this.scopeGraph.addAll(solution.scopeGraph(), this.unifier()::getVars);
        this.nameResolution.addCached(solution.resolutionCache());
        constraints.addAll(this.seed(solution.declProperties(), message).constraints());
        return SeedResult.constraints(constraints);
    }

    public SeedResult seed(IProperties<Occurrence, ITerm, ITerm> solution, IMessageInfo message) throws InterruptedException {
        HashSet constraints = Sets.newHashSet();
        solution.stream().forEach(entry -> this.putProperty((Occurrence)entry._1(), (ITerm)entry._2(), (ITerm)entry._3(), message).ifPresent(constraints::add));
        return SeedResult.constraints(constraints);
    }

    public SolveResult solve(INameResolutionConstraint constraint) throws DelayException {
        return constraint.matchOrThrow(INameResolutionConstraint.CheckedCases.of(this::solve, this::solve, this::solve));
    }

    public NameResolutionResult finish() {
        return NameResolutionResult.of(this.scopeGraph.freeze(), this.nameResolution.toCache(), this.properties.freeze());
    }

    public IProperties.Immutable<Occurrence, ITerm, ITerm> finishDeclProperties() {
        return this.properties.freeze();
    }

    private SolveResult solve(CResolve r) throws DelayException {
        SolveResult result;
        Collection paths;
        ITerm refTerm = r.getReference();
        if (!this.unifier().isGround(refTerm)) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(refTerm));
        }
        Occurrence ref = Occurrence.matcher().match(refTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as first argument to " + r));
        try {
            paths = this.nameResolution.resolve(ref);
        }
        catch (InterruptedException e) {
            throw new InterruptedDelayException(e);
        }
        catch (CriticalEdgeException e) {
            throw new CriticalEdgeDelayException(e);
        }
        HashSet declarations = Sets.newHashSet(Paths.resolutionPathsToDecls(paths));
        switch (declarations.size()) {
            case 0: {
                IMessageInfo message = r.getMessageInfo().withDefaultContent(MessageContent.builder().append(ref).append(" does not resolve.").build());
                result = SolveResult.messages(message);
                break;
            }
            case 1: {
                Occurrence decl = (Occurrence)Iterables.getOnlyElement((Iterable)declarations);
                result = SolveResult.constraints(CEqual.of(r.getDeclaration(), decl, r.getMessageInfo()));
                break;
            }
            default: {
                IMessageInfo message = r.getMessageInfo().withDefaultContent(MessageContent.builder().append("Resolution of ").append(ref).append(" is ambiguous.").build());
                result = SolveResult.messages(message);
            }
        }
        return SolveResult.copyOf(result);
    }

    private SolveResult solve(CAssoc a) throws DelayException {
        SolveResult result;
        ITerm declTerm = a.getDeclaration();
        if (!this.unifier().isGround(declTerm)) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(declTerm));
        }
        Occurrence decl = Occurrence.matcher().match(declTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as first argument to " + a));
        Label label = a.getLabel();
        ArrayList scopes = Lists.newArrayList(this.scopeGraph.getExportEdges().get(decl, label));
        switch (scopes.size()) {
            case 0: {
                IMessageInfo message = a.getMessageInfo().withDefaultContent(MessageContent.builder().append(decl).append(" has no ").append(label).append(" associated scope.").build());
                result = SolveResult.messages(message);
                break;
            }
            case 1: {
                result = SolveResult.constraints(CEqual.of(a.getScope(), (ITerm)scopes.get(0), a.getMessageInfo()));
                break;
            }
            default: {
                IMessageInfo message = a.getMessageInfo().withDefaultContent(MessageContent.builder().append(decl).append(" has multiple ").append(label).append(" associated scope.").build());
                result = SolveResult.messages(message);
            }
        }
        return result;
    }

    private SolveResult solve(CDeclProperty c) throws DelayException {
        ITerm declTerm = c.getDeclaration();
        if (!this.unifier().isGround(declTerm)) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(declTerm));
        }
        Occurrence decl = Occurrence.matcher().match(declTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as first argument to " + c));
        SolveResult result = this.putProperty(decl, c.getKey(), c.getValue(), c.getMessageInfo()).map(cc -> SolveResult.constraints(cc)).orElseGet(() -> SolveResult.empty());
        return result;
    }

    private Optional<IConstraint> putProperty(Occurrence decl, ITerm key, ITerm value, IMessageInfo message) {
        Optional prev = this.properties.getValue(decl, key);
        if (!prev.isPresent()) {
            this.properties.putValue(decl, key, value);
            return Optional.empty();
        }
        return Optional.of(CEqual.of(value, (ITerm)prev.get(), message));
    }

    public Optional<ITerm> getProperty(Occurrence decl, ITerm key) {
        return this.properties.getValue(decl, key);
    }

    @Value.Immutable
    @Serial.Version(value=42L)
    public static abstract class ANameResolutionResult {
        @Value.Parameter
        public abstract IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph();

        @Value.Parameter
        public abstract IEsopNameResolution.ResolutionCache<Scope, Label, Occurrence> resolutionCache();

        @Value.Parameter
        public abstract IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties();
    }
}

