/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mb.nabl2.scopegraph.esop.IEsopNameResolution;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Namespace;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.sets.IElement;
import mb.nabl2.sets.ISetProducer;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;

public class NameSetsComponent
extends ASolver {
    private final IEsopNameResolution<Scope, Label, Occurrence> nameResolution;

    public NameSetsComponent(SolverCore core, IEsopNameResolution<Scope, Label, Occurrence> nameResolution) {
        super(core);
        this.nameResolution = nameResolution;
    }

    public TermMatch.IMatcher<ISetProducer<ITerm>> nameSets() {
        return TermMatch.M.cases(TermMatch.M.appl2("Declarations", Scope.matcher(), Namespace.matcher(), (t, scope, ns) -> () -> {
            Collection<Occurrence> decls = this.nameResolution.decls((Scope)scope);
            return this.makeSet((Iterable<Occurrence>)decls, (Namespace)ns);
        }), TermMatch.M.appl2("References", Scope.matcher(), Namespace.matcher(), (t, scope, ns) -> () -> {
            Collection<Occurrence> refs = this.nameResolution.refs((Scope)scope);
            return this.makeSet((Iterable<Occurrence>)refs, (Namespace)ns);
        }), TermMatch.M.appl2("Visibles", Scope.matcher(), Namespace.matcher(), (t, scope, ns) -> () -> {
            Collection<Occurrence> decls = this.nameResolution.visible((Scope)scope);
            return this.makeSet((Iterable<Occurrence>)decls, (Namespace)ns);
        }), TermMatch.M.appl2("Reachables", Scope.matcher(), Namespace.matcher(), (t, scope, ns) -> () -> {
            Collection<Occurrence> decls = this.nameResolution.reachable((Scope)scope);
            return this.makeSet((Iterable<Occurrence>)decls, (Namespace)ns);
        }));
    }

    private Set<IElement<ITerm>> makeSet(Iterable<Occurrence> occurrences, Namespace namespace) {
        HashSet result = Sets.newHashSet();
        for (Occurrence occurrence : occurrences) {
            if (!namespace.getName().isEmpty() && !namespace.equals(occurrence.getNamespace())) continue;
            result.add(new OccurrenceElement(occurrence));
        }
        return result;
    }

    private static class OccurrenceElement
    implements IElement<ITerm> {
        private final Occurrence occurrence;

        public OccurrenceElement(Occurrence occurrence) {
            this.occurrence = occurrence;
        }

        @Override
        public ITerm getValue() {
            return this.occurrence;
        }

        @Override
        public ITerm getPosition() {
            return this.occurrence.getNameOrIndexOrigin();
        }

        @Override
        public ITerm getName() {
            return this.occurrence.getName();
        }

        @Override
        public Object project(String name) {
            switch (name) {
                case "name": {
                    return this.occurrence.getName();
                }
            }
            throw new IllegalArgumentException("Projection " + name + " undefined for occurrences.");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.occurrence.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OccurrenceElement other = (OccurrenceElement)obj;
            return !(this.occurrence == null ? other.occurrence != null : !this.occurrence.equals(other.occurrence));
        }
    }
}

