/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.AMultiInitialResult;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;

public final class MultiInitialResult
extends AMultiInitialResult
implements Serializable {
    private final ImmutableList<IConstraint> constraints;
    private final ISolution solution;
    private final ITerm customAnalysis;
    private final ImmutableSet<ITermVar> globalVars;
    private final ImmutableSet<Scope> globalScopes;
    private final Fresh.Immutable fresh;
    private static final long serialVersionUID = 42L;

    private MultiInitialResult(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Iterable<? extends ITermVar> globalVars, Iterable<? extends Scope> globalScopes, Fresh.Immutable fresh) {
        this.constraints = ImmutableList.copyOf(constraints);
        this.solution = Objects.requireNonNull(solution, "solution");
        this.customAnalysis = customAnalysis.orElse(null);
        this.globalVars = ImmutableSet.copyOf(globalVars);
        this.globalScopes = ImmutableSet.copyOf(globalScopes);
        this.fresh = Objects.requireNonNull(fresh, "fresh");
    }

    private MultiInitialResult(MultiInitialResult original, ImmutableList<IConstraint> constraints, ISolution solution, ITerm customAnalysis, ImmutableSet<ITermVar> globalVars, ImmutableSet<Scope> globalScopes, Fresh.Immutable fresh) {
        this.constraints = constraints;
        this.solution = solution;
        this.customAnalysis = customAnalysis;
        this.globalVars = globalVars;
        this.globalScopes = globalScopes;
        this.fresh = fresh;
    }

    public ImmutableList<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public ISolution solution() {
        return this.solution;
    }

    @Override
    public Optional<ITerm> customAnalysis() {
        return Optional.ofNullable(this.customAnalysis);
    }

    public ImmutableSet<ITermVar> globalVars() {
        return this.globalVars;
    }

    public ImmutableSet<Scope> globalScopes() {
        return this.globalScopes;
    }

    @Override
    public Fresh.Immutable fresh() {
        return this.fresh;
    }

    public final MultiInitialResult withConstraints(IConstraint ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new MultiInitialResult(this, (ImmutableList<IConstraint>)newValue, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new MultiInitialResult(this, (ImmutableList<IConstraint>)newValue, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    @Override
    public final MultiInitialResult withSolution(ISolution value) {
        if (this.solution == value) {
            return this;
        }
        ISolution newValue = Objects.requireNonNull(value, "solution");
        return new MultiInitialResult(this, this.constraints, newValue, this.customAnalysis, this.globalVars, this.globalScopes, this.fresh);
    }

    @Override
    public final MultiInitialResult withCustomAnalysis(ITerm value) {
        ITerm newValue = Objects.requireNonNull(value, "customAnalysis");
        if (this.customAnalysis == newValue) {
            return this;
        }
        return new MultiInitialResult(this, this.constraints, this.solution, newValue, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withCustomAnalysis(Optional<? extends ITerm> optional) {
        ITerm value = optional.orElse(null);
        if (this.customAnalysis == value) {
            return this;
        }
        return new MultiInitialResult(this, this.constraints, this.solution, value, this.globalVars, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalVars(ITermVar ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, (ImmutableSet<ITermVar>)newValue, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalVars(Iterable<? extends ITermVar> elements) {
        if (this.globalVars == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, (ImmutableSet<ITermVar>)newValue, this.globalScopes, this.fresh);
    }

    public final MultiInitialResult withGlobalScopes(Scope ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, (ImmutableSet<Scope>)newValue, this.fresh);
    }

    public final MultiInitialResult withGlobalScopes(Iterable<? extends Scope> elements) {
        if (this.globalScopes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, (ImmutableSet<Scope>)newValue, this.fresh);
    }

    @Override
    public final MultiInitialResult withFresh(Fresh.Immutable value) {
        if (this.fresh == value) {
            return this;
        }
        Fresh.Immutable newValue = Objects.requireNonNull(value, "fresh");
        return new MultiInitialResult(this, this.constraints, this.solution, this.customAnalysis, this.globalVars, this.globalScopes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultiInitialResult && this.equalTo((MultiInitialResult)another);
    }

    private boolean equalTo(MultiInitialResult another) {
        return this.constraints.equals(another.constraints) && this.solution.equals(another.solution) && Objects.equals(this.customAnalysis, another.customAnalysis) && this.globalVars.equals(another.globalVars) && this.globalScopes.equals(another.globalScopes) && this.fresh.equals(another.fresh);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.solution.hashCode();
        h += (h << 5) + Objects.hashCode(this.customAnalysis);
        h += (h << 5) + this.globalVars.hashCode();
        h += (h << 5) + this.globalScopes.hashCode();
        h += (h << 5) + this.fresh.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MultiInitialResult").omitNullValues().add("constraints", this.constraints).add("solution", (Object)this.solution).add("customAnalysis", (Object)this.customAnalysis).add("globalVars", this.globalVars).add("globalScopes", this.globalScopes).add("fresh", (Object)this.fresh).toString();
    }

    public static MultiInitialResult of(List<IConstraint> constraints, ISolution solution, Optional<ITerm> customAnalysis, Set<ITermVar> globalVars, Set<Scope> globalScopes, Fresh.Immutable fresh) {
        return MultiInitialResult.of(constraints, solution, customAnalysis, globalVars, globalScopes, fresh);
    }

    public static MultiInitialResult of(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Iterable<? extends ITermVar> globalVars, Iterable<? extends Scope> globalScopes, Fresh.Immutable fresh) {
        return new MultiInitialResult(constraints, solution, customAnalysis, globalVars, globalScopes, fresh);
    }

    public static MultiInitialResult copyOf(AMultiInitialResult instance) {
        if (instance instanceof MultiInitialResult) {
            return (MultiInitialResult)instance;
        }
        return MultiInitialResult.of(instance.constraints(), instance.solution(), instance.customAnalysis(), instance.globalVars(), instance.globalScopes(), instance.fresh());
    }
}

