/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.OccurrenceIndex;
import mb.nabl2.scopegraph.terms.path.Paths;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.primitives.AnalysisPrimitive;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.TermIndex;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_get_ast_resolution
extends AnalysisPrimitive {
    public SG_get_ast_resolution() {
        super(SG_get_ast_resolution.class.getSimpleName(), 0);
    }

    @Override
    public Optional<? extends ITerm> call(ISolution solution, ITerm term, List<ITerm> terms) throws InterpreterException {
        return TermIndex.get(term).flatMap(index -> {
            Collection refs = solution.astRefs().get((Object)OccurrenceIndex.of(index));
            ImmutableList.Builder entriesBuilder = ImmutableList.builder();
            try {
                for (Occurrence ref : refs) {
                    try {
                        List decls = Paths.resolutionPathsToDecls(solution.nameResolution().resolve(ref));
                        decls.stream().forEach(decl -> entriesBuilder.add((Object)TermBuild.B.newTuple(ref, decl.getName())));
                    }
                    catch (CriticalEdgeException criticalEdgeException) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedException e) {
                return Optional.empty();
            }
            ImmutableList entries = entriesBuilder.build();
            if (entries.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(TermBuild.B.newList((Iterable<? extends ITerm>)entries));
        });
    }
}

