/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.scopegraph.esop.CriticalEdgeException;
import mb.nabl2.scopegraph.esop.IEsopNameResolution;
import mb.nabl2.scopegraph.terms.Label;
import mb.nabl2.scopegraph.terms.Occurrence;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.scopegraph.terms.path.Paths;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.primitives.AnalysisPrimitive;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_get_decl_resolution
extends AnalysisPrimitive {
    public SG_get_decl_resolution() {
        super(SG_get_decl_resolution.class.getSimpleName(), 0);
    }

    @Override
    public Optional<? extends ITerm> call(ISolution solution, ITerm term, List<ITerm> terms) throws InterpreterException {
        return Occurrence.matcher().match(term, solution.unifier()).flatMap(decl -> {
            IEsopNameResolution<Scope, Label, Occurrence> nameResolution = solution.nameResolution();
            ArrayList entries = Lists.newArrayList();
            for (Occurrence ref : solution.scopeGraph().getAllRefs()) {
                try {
                    Collection paths = nameResolution.resolve(ref);
                    paths.stream().filter(path -> ((Occurrence)path.getDeclaration()).equals(decl)).map(p -> TermBuild.B.newTuple(ref, Paths.toTerm(p))).forEach(entries::add);
                }
                catch (InterruptedException | CriticalEdgeException throwable) {
                    // empty catch block
                }
            }
            return Optional.of(TermBuild.B.newList(entries));
        });
    }
}

