/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.constraints.messages.MessageKind;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.solvers.SemiIncrementalMultiFileSolver;
import mb.nabl2.spoofax.analysis.Actions;
import mb.nabl2.spoofax.analysis.MultiFinalResult;
import mb.nabl2.spoofax.analysis.MultiInitialResult;
import mb.nabl2.spoofax.analysis.MultiUnitResult;
import mb.nabl2.spoofax.primitives.ScopeGraphMultiFileAnalysisPrimitive;
import mb.nabl2.stratego.MessageTerms;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.util.Tuple2;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_solve_multi_final_constraint
extends ScopeGraphMultiFileAnalysisPrimitive {
    private static ILogger logger = LoggerUtils.logger(SG_solve_multi_final_constraint.class);

    public SG_solve_multi_final_constraint() {
        super(SG_solve_multi_final_constraint.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(ITerm currentTerm, List<ITerm> argTerms, SemiIncrementalMultiFileSolver solver, ICancel cancel, IProgress progress) throws InterpreterException {
        ISolution solution;
        Tuple2 input = TermMatch.M.tuple2(TermMatch.M.blobValue(MultiInitialResult.class), TermMatch.M.listElems(TermMatch.M.blobValue(MultiUnitResult.class)), (t, ir, urs) -> Tuple2.of(ir, urs)).match(currentTerm).orElseThrow(() -> new InterpreterException("Current term is not (InitialResult, [UnitResult])."));
        MultiInitialResult initialResult = (MultiInitialResult)input._1();
        List unitResults = (List)input._2();
        Fresh.Transient globalFresh = initialResult.fresh().melt();
        ISolution initialSolution = initialResult.solution();
        List unitSolutions = unitResults.stream().map(MultiUnitResult::solution).collect(Collectors.toList());
        try {
            ISolution preSolution;
            Function1<String, String> fresh = globalFresh::fresh;
            MessageInfo defaultMessage = MessageInfo.of(MessageKind.ERROR, MessageContent.of(), Actions.sourceTerm(""));
            solution = preSolution = solver.solveInter(initialSolution, unitSolutions, defaultMessage, fresh, cancel, progress);
        }
        catch (InterruptedException | SolverException ex) {
            throw new InterpreterException(ex);
        }
        List<IConstraint> constraints = Stream.concat(initialResult.constraints().stream(), unitResults.stream().flatMap(ur -> ur.constraints().stream())).collect(Collectors.toList());
        MultiFinalResult result = MultiFinalResult.of(constraints, solution, Optional.empty(), globalFresh.freeze());
        IMessages.Immutable messages = solution.messagesAndUnsolvedErrors();
        ITerm errors = MessageTerms.toTerms(messages.getErrors(), solution.unifier());
        ITerm warnings = MessageTerms.toTerms(messages.getWarnings(), solution.unifier());
        ITerm notes = MessageTerms.toTerms(messages.getNotes(), solution.unifier());
        ITerm resultTerm = TermBuild.B.newTuple(TermBuild.B.newBlob(result), errors, warnings, notes);
        return Optional.of(resultTerm);
    }
}

