/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.scopegraph.terms.Scope;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.solvers.BaseSolution;
import mb.nabl2.solver.solvers.GraphSolution;
import mb.nabl2.solver.solvers.SemiIncrementalMultiFileSolver;
import mb.nabl2.spoofax.analysis.MultiInitialResult;
import mb.nabl2.spoofax.analysis.MultiUnitResult;
import mb.nabl2.spoofax.primitives.ScopeGraphMultiFileAnalysisPrimitive;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.util.Tuple2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_solve_multi_unit_constraint
extends ScopeGraphMultiFileAnalysisPrimitive {
    private static ILogger logger = LoggerUtils.logger(SG_solve_multi_unit_constraint.class);

    public SG_solve_multi_unit_constraint() {
        super(SG_solve_multi_unit_constraint.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(ITerm currentTerm, List<ITerm> argTerms, SemiIncrementalMultiFileSolver solver, ICancel cancel, IProgress progress) throws InterpreterException {
        ISolution solution;
        Tuple2 input = TermMatch.M.tuple2(TermMatch.M.blobValue(MultiInitialResult.class), Constraints.matchConstraintOrList(), (t, ir, C2) -> Tuple2.of(ir, C2)).match(currentTerm).orElseThrow(() -> new InterpreterException("Current term is not (InitialResult, C)."));
        MultiInitialResult initialResult = (MultiInitialResult)input._1();
        ImmutableList constraints = ImmutableList.of((Object)((IConstraint)input._2()));
        Fresh.Transient unitFresh = Fresh.Transient.of();
        try {
            BaseSolution baseSolution = BaseSolution.of(initialResult.solution().config(), (Iterable<? extends IConstraint>)constraints, initialResult.solution().unifier());
            GraphSolution preSolution = solver.solveGraph(baseSolution, unitFresh::fresh, cancel, progress);
            solution = solver.solveIntra(preSolution, (Collection<ITermVar>)initialResult.globalVars(), (Collection<Scope>)initialResult.globalScopes(), unitFresh::fresh, cancel, progress);
        }
        catch (InterruptedException | SolverException ex) {
            throw new InterpreterException(ex);
        }
        MultiUnitResult result = MultiUnitResult.of((List<IConstraint>)constraints, solution, Optional.empty(), unitFresh.freeze());
        return Optional.of(TermBuild.B.newBlob(result));
    }
}

