/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableMultiset;
import java.util.Objects;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AbstractTerm;
import org.immutables.value.Value;

public abstract class AbstractApplTerm
extends AbstractTerm
implements IApplTerm {
    private volatile int hashCode;

    @Value.Check
    protected abstract IApplTerm check();

    @Override
    @Value.Parameter
    public abstract String getOp();

    @Override
    @Value.Lazy
    public int getArity() {
        return this.getArgs().size();
    }

    @Override
    @Value.Lazy
    public boolean isGround() {
        return this.getArgs().stream().allMatch(ITerm::isGround);
    }

    @Value.Lazy
    public ImmutableMultiset<ITermVar> getVars() {
        ImmutableMultiset.Builder vars = ImmutableMultiset.builder();
        for (ITerm arg : this.getArgs()) {
            vars.addAll(arg.getVars());
        }
        return vars.build();
    }

    @Override
    public <T> T match(ITerm.Cases<T> cases) {
        return cases.caseAppl(this);
    }

    @Override
    public <T, E extends Throwable> T matchOrThrow(ITerm.CheckedCases<T, E> cases) throws E {
        return cases.caseAppl(this);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.getOp(), this.getArity(), this.getArgs());
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IApplTerm)) {
            return false;
        }
        IApplTerm that = (IApplTerm)other;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return Objects.equals(this.getOp(), that.getOp()) && Objects.equals(this.getArity(), that.getArity()) && Objects.equals(this.getArgs(), that.getArgs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOp());
        sb.append("(");
        boolean first = true;
        for (ITerm arg : this.getArgs()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(arg.toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

