/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AApplTerm;

final class ApplTerm
extends AApplTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final String op;
    private final ImmutableList<ITerm> args;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ARITY_LAZY_INIT_BIT = 1L;
    private transient int arity;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long VARS_LAZY_INIT_BIT = 4L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private ApplTerm(String op, Iterable<? extends ITerm> args) {
        this.op = Objects.requireNonNull(op, "op");
        this.args = ImmutableList.copyOf(args);
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private ApplTerm(ImmutableClassToInstanceMap<Object> attachments, String op, ImmutableList<ITerm> args) {
        this.attachments = attachments;
        this.op = op;
        this.args = args;
        this.hashCode = super.hashCode();
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    public ImmutableList<ITerm> getArgs() {
        return this.args;
    }

    @Override
    public final ApplTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return ApplTerm.validate(new ApplTerm(newValue, this.op, this.args));
    }

    public final ApplTerm withOp(String value) {
        String newValue = Objects.requireNonNull(value, "op");
        if (this.op.equals(newValue)) {
            return this;
        }
        return ApplTerm.validate(new ApplTerm(this.attachments, newValue, this.args));
    }

    public final ApplTerm withArgs(ITerm ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ApplTerm.validate(new ApplTerm(this.attachments, this.op, (ImmutableList<ITerm>)newValue));
    }

    public final ApplTerm withArgs(Iterable<? extends ITerm> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ApplTerm.validate(new ApplTerm(this.attachments, this.op, (ImmutableList<ITerm>)newValue));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArity() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ApplTerm applTerm = this;
            synchronized (applTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.arity = super.getArity();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ApplTerm applTerm = this;
            synchronized (applTerm) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ApplTerm applTerm = this;
            synchronized (applTerm) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.vars;
    }

    public static ApplTerm of(String op, List<ITerm> args) {
        return ApplTerm.of(op, args);
    }

    public static ApplTerm of(String op, Iterable<? extends ITerm> args) {
        return ApplTerm.validate(new ApplTerm(op, args));
    }

    private static ApplTerm validate(ApplTerm instance) {
        instance = (ApplTerm)instance.check();
        return instance;
    }

    public static ApplTerm copyOf(AApplTerm instance) {
        if (instance instanceof ApplTerm) {
            return (ApplTerm)instance;
        }
        return ApplTerm.of(instance.getOp(), instance.getArgs()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return ApplTerm.validate(new ApplTerm(this.attachments, this.op, this.args));
    }
}

