/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.ABlobTerm;

final class BlobTerm
extends ABlobTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final Object value;
    private volatile transient long lazyInitBitmap;
    private static final long VARS_LAZY_INIT_BIT = 1L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private BlobTerm(Object value) {
        this.value = Objects.requireNonNull(value, "value");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private BlobTerm(ImmutableClassToInstanceMap<Object> attachments, Object value) {
        this.attachments = attachments;
        this.value = value;
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public final BlobTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new BlobTerm(newValue, this.value);
    }

    public final BlobTerm withValue(Object value) {
        if (this.value == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "value");
        return new BlobTerm(this.attachments, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            BlobTerm blobTerm = this;
            synchronized (blobTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vars;
    }

    public static BlobTerm of(Object value) {
        return new BlobTerm(value);
    }

    public static BlobTerm copyOf(ABlobTerm instance) {
        if (instance instanceof BlobTerm) {
            return (BlobTerm)instance;
        }
        return BlobTerm.of(instance.getValue()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }
}

