/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AConsTerm;

final class ConsTerm
extends AConsTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final ITerm head;
    private final IListTerm tail;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long MIN_SIZE_LAZY_INIT_BIT = 1L;
    private transient int minSize;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long VARS_LAZY_INIT_BIT = 4L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private ConsTerm(ITerm head, IListTerm tail) {
        this.head = Objects.requireNonNull(head, "head");
        this.tail = Objects.requireNonNull(tail, "tail");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private ConsTerm(ImmutableClassToInstanceMap<Object> attachments, ITerm head, IListTerm tail) {
        this.attachments = attachments;
        this.head = head;
        this.tail = tail;
        this.hashCode = super.hashCode();
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public ITerm getHead() {
        return this.head;
    }

    @Override
    public IListTerm getTail() {
        return this.tail;
    }

    @Override
    public final ConsTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new ConsTerm(newValue, this.head, this.tail);
    }

    public final ConsTerm withHead(ITerm value) {
        if (this.head == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "head");
        return new ConsTerm(this.attachments, newValue, this.tail);
    }

    public final ConsTerm withTail(IListTerm value) {
        if (this.tail == value) {
            return this;
        }
        IListTerm newValue = Objects.requireNonNull(value, "tail");
        return new ConsTerm(this.attachments, this.head, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinSize() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ConsTerm consTerm = this;
            synchronized (consTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.minSize = super.getMinSize();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.minSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ConsTerm consTerm = this;
            synchronized (consTerm) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ConsTerm consTerm = this;
            synchronized (consTerm) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.vars;
    }

    public static ConsTerm of(ITerm head, IListTerm tail) {
        return new ConsTerm(head, tail);
    }

    public static ConsTerm copyOf(AConsTerm instance) {
        if (instance instanceof ConsTerm) {
            return (ConsTerm)instance;
        }
        return ConsTerm.of(instance.getHead(), instance.getTail()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new ConsTerm(this.attachments, this.head, this.tail);
    }
}

