/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AIntTerm;

final class IntTerm
extends AIntTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final int value;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long VARS_LAZY_INIT_BIT = 1L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private IntTerm(int value) {
        this.value = value;
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private IntTerm(ImmutableClassToInstanceMap<Object> attachments, int value) {
        this.attachments = attachments;
        this.value = value;
        this.hashCode = super.hashCode();
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public final IntTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new IntTerm(newValue, this.value);
    }

    public final IntTerm withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new IntTerm(this.attachments, value);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            IntTerm intTerm = this;
            synchronized (intTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vars;
    }

    public static IntTerm of(int value) {
        return new IntTerm(value);
    }

    public static IntTerm copyOf(AIntTerm instance) {
        if (instance instanceof IntTerm) {
            return (IntTerm)instance;
        }
        return IntTerm.of(instance.getValue()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new IntTerm(this.attachments, this.value);
    }
}

