/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.ANilTerm;

final class NilTerm
extends ANilTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final int minSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long VARS_LAZY_INIT_BIT = 1L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final NilTerm INSTANCE = NilTerm.validate(new NilTerm());
    private static final long serialVersionUID = 42L;

    private NilTerm() {
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    private NilTerm(ImmutableClassToInstanceMap<Object> attachments) {
        this.initShim.attachments(attachments);
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttachments() : this.attachments;
    }

    @Override
    public int getMinSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinSize() : this.minSize;
    }

    @Override
    public final NilTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return NilTerm.validate(new NilTerm(newValue));
    }

    private boolean equalTo(NilTerm another) {
        return super.equals(another);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            NilTerm nilTerm = this;
            synchronized (nilTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vars;
    }

    public static NilTerm of() {
        return INSTANCE;
    }

    private static NilTerm validate(NilTerm instance) {
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return NilTerm.validate(this);
    }

    private final class InitShim {
        private byte attachmentsBuildStage = 0;
        private ImmutableClassToInstanceMap<Object> attachments;
        private byte minSizeBuildStage = 0;
        private int minSize;

        private InitShim() {
        }

        ImmutableClassToInstanceMap<Object> getAttachments() {
            if (this.attachmentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentsBuildStage == 0) {
                this.attachmentsBuildStage = (byte)-1;
                this.attachments = Objects.requireNonNull(NilTerm.super.getAttachments(), "attachments");
                this.attachmentsBuildStage = 1;
            }
            return this.attachments;
        }

        void attachments(ImmutableClassToInstanceMap<Object> attachments) {
            this.attachments = attachments;
            this.attachmentsBuildStage = 1;
        }

        int getMinSize() {
            if (this.minSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSizeBuildStage == 0) {
                this.minSizeBuildStage = (byte)-1;
                this.minSize = NilTerm.super.getMinSize();
                this.minSizeBuildStage = 1;
            }
            return this.minSize;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.attachmentsBuildStage == -1) {
                attributes.add("attachments");
            }
            if (this.minSizeBuildStage == -1) {
                attributes.add("minSize");
            }
            return "Cannot build NilTerm, attribute initializers form cycle " + attributes;
        }
    }
}

