/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AStringTerm;

final class StringTerm
extends AStringTerm
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final String value;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long VARS_LAZY_INIT_BIT = 1L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private StringTerm(String value) {
        this.value = Objects.requireNonNull(value, "value");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private StringTerm(ImmutableClassToInstanceMap<Object> attachments, String value) {
        this.attachments = attachments;
        this.value = value;
        this.hashCode = super.hashCode();
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public final StringTerm withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new StringTerm(newValue, this.value);
    }

    public final StringTerm withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new StringTerm(this.attachments, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            StringTerm stringTerm = this;
            synchronized (stringTerm) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vars;
    }

    public static StringTerm of(String value) {
        return new StringTerm(value);
    }

    public static StringTerm copyOf(AStringTerm instance) {
        if (instance instanceof StringTerm) {
            return (StringTerm)instance;
        }
        return StringTerm.of(instance.getValue()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new StringTerm(this.attachments, this.value);
    }
}

