/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.ApplTerm;
import mb.nabl2.terms.build.BlobTerm;
import mb.nabl2.terms.build.ConsTerm;
import mb.nabl2.terms.build.IntTerm;
import mb.nabl2.terms.build.NilTerm;
import mb.nabl2.terms.build.StringTerm;
import mb.nabl2.terms.build.TermVar;

public class TermBuild {
    public static final B B = new B();

    public static class B {
        public final IApplTerm EMPTY_TUPLE = this.newAppl("", (Iterable<? extends ITerm>)ImmutableList.of());
        public final IListTerm EMPTY_LIST = this.newNil();

        public IApplTerm newAppl(String op, ITerm ... args) {
            return this.newAppl(op, Arrays.asList(args));
        }

        public IApplTerm newAppl(String op, Iterable<? extends ITerm> args) {
            return this.newAppl(op, args, null);
        }

        public IApplTerm newAppl(String op, Iterable<? extends ITerm> args, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            ApplTerm term = ApplTerm.of(op, args);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public ITerm newTuple(ITerm ... args) {
            return this.newTuple(Arrays.asList(args));
        }

        public ITerm newTuple(Iterable<? extends ITerm> args) {
            return this.newTuple(args, null);
        }

        public ITerm newTuple(Iterable<? extends ITerm> args, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            return Iterables.size(args) == 1 ? (ITerm)Iterables.getOnlyElement(args) : this.newAppl("", args, attachments);
        }

        public IListTerm newList(ITerm ... elems) {
            return this.newList(Arrays.asList(elems));
        }

        public IListTerm newList(Iterable<? extends ITerm> elems) {
            return this.newList(elems, null);
        }

        public IListTerm newList(Iterable<? extends ITerm> elems, @Nullable Iterable<ImmutableClassToInstanceMap<Object>> attachments) {
            LinkedList attachmentsQueue;
            LinkedList elemsQueue = Lists.newLinkedList(elems);
            LinkedList linkedList = attachmentsQueue = attachments != null ? Lists.newLinkedList(attachments) : null;
            if (attachmentsQueue != null && attachmentsQueue.size() != elemsQueue.size() + 1) {
                throw new IllegalArgumentException("Number of attachments does not correspond to number of elements in the list.");
            }
            ITerm list = this.newNil();
            if (attachmentsQueue != null) {
                list = list.withAttachments((ImmutableClassToInstanceMap)attachmentsQueue.removeLast());
            }
            return this.newListTail(elemsQueue, (IListTerm)list, attachmentsQueue);
        }

        public IListTerm newListTail(Iterable<? extends ITerm> elems, IListTerm list) {
            return this.newListTail(elems, list, null);
        }

        public IListTerm newListTail(Iterable<? extends ITerm> elems, IListTerm list, @Nullable Iterable<ImmutableClassToInstanceMap<Object>> attachments) {
            LinkedList attachmentsQueue;
            LinkedList elemsQueue = Lists.newLinkedList(elems);
            LinkedList linkedList = attachmentsQueue = attachments != null ? Lists.newLinkedList(attachments) : null;
            if (attachmentsQueue != null && attachmentsQueue.size() != elemsQueue.size()) {
                throw new IllegalArgumentException("Number of attachments does not correspond to number of elements in the list.");
            }
            return this.newListTail(elemsQueue, list, attachmentsQueue);
        }

        private IListTerm newListTail(LinkedList<? extends ITerm> elems, IListTerm list, @Nullable LinkedList<ImmutableClassToInstanceMap<Object>> attachments) {
            while (!elems.isEmpty()) {
                list = this.newCons(elems.removeLast(), (IListTerm)list);
                if (attachments == null) continue;
                list = list.withAttachments((ImmutableClassToInstanceMap)attachments.removeLast());
            }
            return list;
        }

        public INilTerm newNil() {
            return this.newNil(null);
        }

        public INilTerm newNil(@Nullable ImmutableClassToInstanceMap<Object> attachments) {
            NilTerm term = NilTerm.of();
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public IConsTerm newCons(ITerm head, IListTerm tail) {
            return this.newCons(head, tail, null);
        }

        public IConsTerm newCons(ITerm head, IListTerm tail, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            ConsTerm term = ConsTerm.of(head, tail);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public IStringTerm newString(String value) {
            return this.newString(value, null);
        }

        public IStringTerm newString(String value, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            StringTerm term = StringTerm.of(value);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public IIntTerm newInt(int value) {
            return this.newInt(value, null);
        }

        public IIntTerm newInt(int value, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            IntTerm term = IntTerm.of(value);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public IBlobTerm newBlob(Object value) {
            return this.newBlob(value, null);
        }

        public IBlobTerm newBlob(Object value, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            BlobTerm term = BlobTerm.of(value);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }

        public ITermVar newVar(String resource, String name) {
            return this.newVar(resource, name, null);
        }

        public ITermVar newVar(String resource, String name, @Nullable ImmutableClassToInstanceMap<Object> attachments) {
            TermVar term = TermVar.of(resource, name);
            return attachments != null ? term.withAttachments((ImmutableClassToInstanceMap)attachments) : term;
        }
    }
}

