/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.ATermVar;

public final class TermVar
extends ATermVar
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final int minSize;
    private final String resource;
    private final String name;
    private final int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long VARS_LAZY_INIT_BIT = 1L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long serialVersionUID = 42L;

    private TermVar(String resource, String name) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.hashCode = super.hashCode();
        this.initShim = null;
    }

    private TermVar(ImmutableClassToInstanceMap<Object> attachments, String resource, String name) {
        this.initShim.attachments(attachments);
        this.resource = resource;
        this.name = name;
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.hashCode = super.hashCode();
        this.initShim = null;
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttachments() : this.attachments;
    }

    @Override
    public int getMinSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinSize() : this.minSize;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final TermVar withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return TermVar.validate(new TermVar(newValue, this.resource, this.name));
    }

    public final TermVar withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return TermVar.validate(new TermVar(this.attachments, newValue, this.name));
    }

    public final TermVar withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return TermVar.validate(new TermVar(this.attachments, this.resource, newValue));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            TermVar termVar = this;
            synchronized (termVar) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vars;
    }

    public static TermVar of(String resource, String name) {
        return TermVar.validate(new TermVar(resource, name));
    }

    private static TermVar validate(TermVar instance) {
        instance.check();
        return instance;
    }

    public static TermVar copyOf(ATermVar instance) {
        if (instance instanceof TermVar) {
            return (TermVar)instance;
        }
        return TermVar.of(instance.getResource(), instance.getName()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return TermVar.validate(new TermVar(this.attachments, this.resource, this.name));
    }

    private final class InitShim {
        private byte attachmentsBuildStage = 0;
        private ImmutableClassToInstanceMap<Object> attachments;
        private byte minSizeBuildStage = 0;
        private int minSize;

        private InitShim() {
        }

        ImmutableClassToInstanceMap<Object> getAttachments() {
            if (this.attachmentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentsBuildStage == 0) {
                this.attachmentsBuildStage = (byte)-1;
                this.attachments = Objects.requireNonNull(TermVar.super.getAttachments(), "attachments");
                this.attachmentsBuildStage = 1;
            }
            return this.attachments;
        }

        void attachments(ImmutableClassToInstanceMap<Object> attachments) {
            this.attachments = attachments;
            this.attachmentsBuildStage = 1;
        }

        int getMinSize() {
            if (this.minSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSizeBuildStage == 0) {
                this.minSizeBuildStage = (byte)-1;
                this.minSize = TermVar.super.getMinSize();
                this.minSizeBuildStage = 1;
            }
            return this.minSize;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.attachmentsBuildStage == -1) {
                attributes.add("attachments");
            }
            if (this.minSizeBuildStage == -1) {
                attributes.add("minSize");
            }
            return "Cannot build TermVar, attribute initializers form cycle " + attributes;
        }
    }
}

