/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.collection;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;

public class VarMultiset {
    private final Multiset<ITermVar> vars = HashMultiset.create();

    public boolean add(ITermVar var, IUnifier unifier) {
        return this.add(var, 1, unifier);
    }

    public boolean add(ITermVar var, int n, IUnifier unifier) {
        Multiset<ITermVar> reps = unifier.findRecursive(var).getVars();
        boolean change = false;
        for (ITermVar rep : reps) {
            this.vars.add((Object)rep, n);
            change |= n > 0;
        }
        return change;
    }

    public boolean addAll(Collection<ITermVar> vars, IUnifier unifier) {
        boolean change = false;
        for (ITermVar var : vars) {
            change |= this.add(var, unifier);
        }
        return change;
    }

    public boolean remove(ITermVar var, IUnifier unifier) {
        return this.remove(var, 1, unifier);
    }

    public boolean remove(ITermVar var, int n, IUnifier unifier) {
        Multiset<ITermVar> reps = unifier.findRecursive(var).getVars();
        boolean change = false;
        for (ITermVar rep : reps) {
            int prev_n = this.vars.remove((Object)rep, n);
            change |= prev_n > 0 && n > 0;
        }
        return change;
    }

    public boolean removeAll(Collection<ITermVar> vars, IUnifier unifier) {
        boolean change = false;
        for (ITermVar var : vars) {
            change |= this.remove(var, unifier);
        }
        return change;
    }

    public boolean contains(ITermVar var, IUnifier unifier) {
        return this.count(var, unifier) > 0;
    }

    public int count(ITermVar var, IUnifier unifier) {
        Multiset<ITermVar> reps = unifier.findRecursive(var).getVars();
        int n = 0;
        for (ITermVar rep : reps.elementSet()) {
            n += this.vars.count((Object)rep);
        }
        return n;
    }

    public int size() {
        return this.vars.size();
    }

    public Set<ITermVar> varSet() {
        return Collections.unmodifiableSet(this.vars.elementSet());
    }

    public boolean update(Collection<ITermVar> vars, IUnifier unifier) {
        boolean change = false;
        for (ITermVar var : vars) {
            change |= this.update(var, unifier);
        }
        return change;
    }

    public boolean update(ITermVar var, IUnifier unifier) {
        int n = this.vars.remove((Object)var, this.vars.count((Object)var));
        if (n > 0) {
            Multiset<ITermVar> reps = unifier.findRecursive(var).getVars();
            for (ITermVar rep : reps) {
                this.vars.add((Object)rep, n);
            }
            return true;
        }
        return false;
    }
}

