/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

class ApplPattern
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final String op;
    private final List<Pattern> args;

    public ApplPattern(String op, Iterable<? extends Pattern> args, ImmutableClassToInstanceMap<Object> attachments) {
        super(attachments);
        this.op = op;
        this.args = ImmutableList.copyOf(args);
    }

    public String getOp() {
        return this.op;
    }

    public List<Pattern> getArgs() {
        return this.args;
    }

    @Override
    public Set<ITermVar> getVars() {
        ImmutableSet.Builder vars = ImmutableSet.builder();
        for (Pattern arg : this.args) {
            vars.addAll(arg.getVars());
        }
        return vars.build();
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return unifier.findTerm(term).match(Terms.cases().appl(applTerm -> {
            if (applTerm.getArity() == this.args.size() && applTerm.getOp().equals(this.op)) {
                return ApplPattern.matchTerms(this.args, applTerm.getArgs(), subst, unifier, eqs);
            }
            return false;
        }).var(v -> {
            eqs.add((ITermVar)v, this);
            return true;
        }).otherwise(t -> false));
    }

    @Override
    public Pattern apply(IRenaming subst) {
        return new ApplPattern(this.op, (Iterable)this.args.stream().map(p -> p.apply(subst)).collect(ImmutableList.toImmutableList()), this.getAttachments());
    }

    @Override
    public ApplPattern eliminateWld(Function0<ITermVar> fresh) {
        return new ApplPattern(this.op, (Iterable)this.args.stream().map(p -> p.eliminateWld(fresh)).collect(ImmutableList.toImmutableList()), this.getAttachments());
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        return TermBuild.B.newAppl(this.op, (Iterable)this.args.stream().map(a -> a.asTerm(equalities, fresh)).collect(ImmutableList.toImmutableList()), this.getAttachments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.op).append("(").append(this.args).append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplPattern that = (ApplPattern)o;
        return Objects.equals(this.op, that.op) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.op, this.args);
    }
}

