/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.iterators.Iterables2;

class ConsPattern
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final Pattern head;
    private final Pattern tail;

    public ConsPattern(Pattern head, Pattern tail, ImmutableClassToInstanceMap<Object> attachments) {
        super(attachments);
        this.head = head;
        this.tail = tail;
    }

    public Pattern getHead() {
        return this.head;
    }

    public Pattern getTail() {
        return this.tail;
    }

    @Override
    public Set<ITermVar> getVars() {
        ImmutableSet.Builder vars = ImmutableSet.builder();
        vars.addAll(this.head.getVars());
        vars.addAll(this.tail.getVars());
        return vars.build();
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return TermMatch.M.list(listTerm -> listTerm.match(ListTerms.cases().cons(consTerm -> ConsPattern.matchTerms(Iterables2.from(this.head, this.tail), Iterables2.from(consTerm.getHead(), consTerm.getTail()), subst, unifier, eqs)).var(v -> {
            eqs.add((ITermVar)v, this);
            return true;
        }).otherwise(t -> false))).match(unifier.findTerm(term)).orElse(false);
    }

    @Override
    public ConsPattern apply(IRenaming subst) {
        return new ConsPattern(this.head.apply(subst), this.tail.apply(subst), this.getAttachments());
    }

    @Override
    public ConsPattern eliminateWld(Function0<ITermVar> fresh) {
        return new ConsPattern(this.head.eliminateWld(fresh), this.tail.eliminateWld(fresh), this.getAttachments());
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        return TermBuild.B.newCons(this.head.asTerm(equalities, fresh), (IListTerm)this.tail.asTerm(equalities, fresh), this.getAttachments());
    }

    public String toString() {
        return "[" + this.head.toString() + "|" + this.tail.toString() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsPattern that = (ConsPattern)o;
        return Objects.equals(this.head, that.head) && Objects.equals(this.tail, that.tail);
    }

    public int hashCode() {
        return Objects.hash(this.head, this.tail);
    }
}

