/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.AMatchResult;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.Tuple2;

public final class MatchResult
extends AMatchResult
implements Serializable {
    private final ISubstitution.Immutable substitution;
    private final ImmutableSet<ITermVar> constrainedVars;
    private final ImmutableList<Tuple2<ITerm, ITerm>> equalities;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private MatchResult(ISubstitution.Immutable substitution, Iterable<? extends ITermVar> constrainedVars, Iterable<? extends Tuple2<ITerm, ITerm>> equalities) {
        this.substitution = Objects.requireNonNull(substitution, "substitution");
        this.constrainedVars = ImmutableSet.copyOf(constrainedVars);
        this.equalities = ImmutableList.copyOf(equalities);
        this.hashCode = this.computeHashCode();
    }

    private MatchResult(MatchResult original, ISubstitution.Immutable substitution, ImmutableSet<ITermVar> constrainedVars, ImmutableList<Tuple2<ITerm, ITerm>> equalities) {
        this.substitution = substitution;
        this.constrainedVars = constrainedVars;
        this.equalities = equalities;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ISubstitution.Immutable substitution() {
        return this.substitution;
    }

    public ImmutableSet<ITermVar> constrainedVars() {
        return this.constrainedVars;
    }

    public ImmutableList<Tuple2<ITerm, ITerm>> equalities() {
        return this.equalities;
    }

    public final MatchResult withSubstitution(ISubstitution.Immutable value) {
        if (this.substitution == value) {
            return this;
        }
        ISubstitution.Immutable newValue = Objects.requireNonNull(value, "substitution");
        return new MatchResult(this, newValue, this.constrainedVars, this.equalities);
    }

    public final MatchResult withConstrainedVars(ITermVar ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new MatchResult(this, this.substitution, (ImmutableSet<ITermVar>)newValue, this.equalities);
    }

    public final MatchResult withConstrainedVars(Iterable<? extends ITermVar> elements) {
        if (this.constrainedVars == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new MatchResult(this, this.substitution, (ImmutableSet<ITermVar>)newValue, this.equalities);
    }

    @SafeVarargs
    public final MatchResult withEqualities(Tuple2<ITerm, ITerm> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new MatchResult(this, this.substitution, this.constrainedVars, (ImmutableList<Tuple2<ITerm, ITerm>>)newValue);
    }

    public final MatchResult withEqualities(Iterable<? extends Tuple2<ITerm, ITerm>> elements) {
        if (this.equalities == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new MatchResult(this, this.substitution, this.constrainedVars, (ImmutableList<Tuple2<ITerm, ITerm>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MatchResult && this.equalTo((MatchResult)another);
    }

    private boolean equalTo(MatchResult another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.substitution.equals(another.substitution) && this.constrainedVars.equals(another.constrainedVars) && this.equalities.equals(another.equalities);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.substitution.hashCode();
        h += (h << 5) + this.constrainedVars.hashCode();
        h += (h << 5) + this.equalities.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MatchResult").omitNullValues().add("substitution", (Object)this.substitution).add("constrainedVars", this.constrainedVars).add("equalities", this.equalities).toString();
    }

    public static MatchResult of(ISubstitution.Immutable substitution, Set<ITermVar> constrainedVars, List<Tuple2<ITerm, ITerm>> equalities) {
        return MatchResult.of(substitution, constrainedVars, equalities);
    }

    public static MatchResult of(ISubstitution.Immutable substitution, Iterable<? extends ITermVar> constrainedVars, Iterable<? extends Tuple2<ITerm, ITerm>> equalities) {
        return new MatchResult(substitution, constrainedVars, equalities);
    }

    public static MatchResult copyOf(AMatchResult instance) {
        if (instance instanceof MatchResult) {
            return (MatchResult)instance;
        }
        return MatchResult.of(instance.substitution(), instance.constrainedVars(), instance.equalities());
    }

    private Object readResolve() throws ObjectStreamException {
        return new MatchResult(this, this.substitution, this.constrainedVars, this.equalities);
    }
}

