/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.PatternVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.iterators.Iterables2;

class PatternAs
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final PatternVar var;
    private final Pattern pattern;

    public PatternAs(String name, Pattern pattern) {
        this(TermBuild.B.newVar("", name), pattern);
    }

    public PatternAs(ITermVar var, Pattern pattern) {
        super((ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        this.var = new PatternVar(var);
        this.pattern = pattern;
    }

    PatternAs(PatternVar var, Pattern pattern) {
        super((ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        this.var = var;
        this.pattern = pattern;
    }

    PatternAs(Pattern pattern) {
        super((ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        this.var = new PatternVar();
        this.pattern = pattern;
    }

    @Nullable
    ITermVar getVar() {
        return this.var.getVar();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Set<ITermVar> getVars() {
        ImmutableSet.Builder vars = ImmutableSet.builder();
        vars.addAll(this.var.getVars());
        vars.addAll(this.pattern.getVars());
        return vars.build();
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return PatternAs.matchTerms(Iterables2.from(this.var, this.pattern), Iterables2.from(term, term), subst, unifier, eqs);
    }

    @Override
    public PatternAs apply(IRenaming subst) {
        return new PatternAs(this.var.apply(subst), this.pattern.apply(subst));
    }

    @Override
    public PatternAs eliminateWld(Function0<ITermVar> fresh) {
        return new PatternAs((PatternVar)this.var.eliminateWld((Function0)fresh), this.pattern.eliminateWld(fresh));
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        ITerm term = this.pattern.asTerm(equalities, fresh);
        if (!this.var.isWildcard()) {
            equalities.apply(this.var.getVar(), term);
        }
        return term;
    }

    public String toString() {
        return String.valueOf(this.var.toString()) + "@" + this.pattern.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternAs patternAs = (PatternAs)o;
        return Objects.equals(this.var, patternAs.var) && Objects.equals(this.pattern, patternAs.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.var, this.pattern);
    }
}

