/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

class PatternVar
extends Pattern {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final ITermVar var;

    public PatternVar() {
        super((ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        this.var = null;
    }

    public PatternVar(String name) {
        this(TermBuild.B.newVar("", name));
    }

    public PatternVar(ITermVar var) {
        super(var != null ? var.getAttachments() : ImmutableClassToInstanceMap.of());
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.var = var;
    }

    @Nullable
    ITermVar getVar() {
        return this.var;
    }

    public boolean isWildcard() {
        return this.var == null;
    }

    @Override
    public Set<ITermVar> getVars() {
        return this.isWildcard() ? ImmutableSet.of() : ImmutableSet.of((Object)this.var);
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        if (this.isWildcard()) {
            return true;
        }
        if (subst.contains(this.var)) {
            Optional<? extends IUnifier.Immutable> diff = unifier.diff(subst.apply(this.var), term);
            if (!diff.isPresent()) {
                return false;
            }
            diff.get().equalityMap().forEach(eqs::add);
            return true;
        }
        subst.put(this.var, term);
        return true;
    }

    @Override
    public PatternVar apply(IRenaming subst) {
        return this.isWildcard() ? this : new PatternVar(subst.rename(this.var));
    }

    @Override
    public PatternVar eliminateWld(Function0<ITermVar> fresh) {
        return this.isWildcard() ? new PatternVar(fresh.apply()) : this;
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        return fresh.apply(Optional.ofNullable(this.var));
    }

    public String toString() {
        return this.isWildcard() ? "_" : this.var.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternVar that = (PatternVar)o;
        return Objects.equals(this.var, that.var);
    }

    public int hashCode() {
        return Objects.hash(this.var);
    }
}

