/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.AMatchResult;
import mb.nabl2.terms.matching.ApplPattern;
import mb.nabl2.terms.matching.ConsPattern;
import mb.nabl2.terms.matching.IntPattern;
import mb.nabl2.terms.matching.MaybeNotInstantiated;
import mb.nabl2.terms.matching.NilPattern;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.PatternAs;
import mb.nabl2.terms.matching.PatternVar;
import mb.nabl2.terms.matching.StringPattern;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate1;

public class TermPattern {
    public static P P = new P();

    public static class P {
        public Pattern newAppl(String op, Pattern ... args) {
            return this.newAppl(op, Arrays.asList(args), (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newAppl(String op, Iterable<? extends Pattern> args, ImmutableClassToInstanceMap<Object> attachments) {
            if (op.equals("")) {
                throw new IllegalArgumentException();
            }
            return new ApplPattern(op, args, attachments);
        }

        public Pattern newTuple(Pattern ... args) {
            return this.newTuple(Arrays.asList(args), (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newTuple(Iterable<? extends Pattern> args) {
            return this.newTuple(args, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newTuple(Iterable<? extends Pattern> args, ImmutableClassToInstanceMap<Object> attachments) {
            ImmutableList argList = ImmutableList.copyOf(args);
            if (argList.size() == 1) {
                return (Pattern)argList.get(0);
            }
            return new ApplPattern("", (Iterable<? extends Pattern>)argList, attachments);
        }

        public Pattern newList(Iterable<? extends Pattern> args) {
            return this.newListTail(args, this.newNil(), (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newList(Iterable<? extends Pattern> args, ImmutableClassToInstanceMap<Object> attachments) {
            return this.newListTail(args, this.newNil(attachments), attachments);
        }

        public Pattern newListTail(Iterable<? extends Pattern> args, Pattern tail) {
            return this.newListTail(args, tail, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newListTail(Iterable<? extends Pattern> args, Pattern tail, ImmutableClassToInstanceMap<Object> attachments) {
            Pattern list = tail;
            for (Pattern elem : ImmutableList.copyOf(args).reverse()) {
                list = this.newCons(elem, list, attachments);
            }
            return list;
        }

        public Pattern newCons(Pattern head, Pattern tail, ImmutableClassToInstanceMap<Object> attachments) {
            return new ConsPattern(head, tail, attachments);
        }

        public Pattern newNil() {
            return new NilPattern((ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newNil(ImmutableClassToInstanceMap<Object> attachments) {
            return new NilPattern(attachments);
        }

        public Pattern newString(String value) {
            return new StringPattern(value, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newString(String value, ImmutableClassToInstanceMap<Object> attachments) {
            return new StringPattern(value, attachments);
        }

        public Pattern newInt(int value) {
            return new IntPattern(value, (ImmutableClassToInstanceMap<Object>)ImmutableClassToInstanceMap.of());
        }

        public Pattern newInt(int value, ImmutableClassToInstanceMap<Object> attachments) {
            return new IntPattern(value, attachments);
        }

        public Pattern newWld() {
            return new PatternVar();
        }

        public Pattern newVar(String name) {
            return new PatternVar(name);
        }

        public Pattern newVar(ITermVar var) {
            return new PatternVar(var);
        }

        public Pattern newAs(String name, Pattern pattern) {
            return new PatternAs(name, pattern);
        }

        public Pattern newAs(ITermVar var, Pattern pattern) {
            return new PatternAs(var, pattern);
        }

        public Pattern newAs(Pattern pattern) {
            return new PatternAs(pattern);
        }

        public Pattern fromTerm(ITerm term) {
            return this.fromTerm(term, v -> false);
        }

        public Pattern fromTerm(ITerm term, Predicate1<ITermVar> isWildcard) {
            return term.match(Terms.cases(appl -> {
                List args = (List)appl.getArgs().stream().map(a -> this.fromTerm((ITerm)a, isWildcard)).collect(ImmutableList.toImmutableList());
                return new ApplPattern(appl.getOp(), args, appl.getAttachments());
            }, list -> list.match(ListTerms.cases(cons -> new ConsPattern(this.fromTerm(cons.getHead(), isWildcard), this.fromTerm(cons.getTail(), isWildcard), cons.getAttachments()), nil -> new NilPattern(nil.getAttachments()), var -> isWildcard.test((ITermVar)var) ? new PatternVar() : new PatternVar((ITermVar)var))), string -> new StringPattern(string.getValue(), string.getAttachments()), integer -> new IntPattern(integer.getValue(), integer.getAttachments()), blob -> {
                throw new IllegalArgumentException("Cannot create blob patterns.");
            }, var -> isWildcard.test((ITermVar)var) ? new PatternVar() : new PatternVar((ITermVar)var)));
        }

        public Optional<ISubstitution.Immutable> match(Iterable<Pattern> patterns, Iterable<ITerm> terms) {
            return P.newTuple(patterns).match(TermBuild.B.newTuple(terms));
        }

        public MaybeNotInstantiated<Optional<ISubstitution.Immutable>> match(Iterable<Pattern> patterns, Iterable<? extends ITerm> terms, IUnifier.Immutable unifier) {
            return P.newTuple(patterns).match(TermBuild.B.newTuple(terms), unifier);
        }

        public Optional<AMatchResult> matchWithEqs(Iterable<Pattern> patterns, Iterable<? extends ITerm> terms, IUnifier.Immutable unifier, Function1<Optional<ITermVar>, ITermVar> fresh) {
            return P.newTuple(patterns).matchWithEqs(TermBuild.B.newTuple(terms), unifier, fresh);
        }
    }
}

