/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermOrigin;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ATermOrigin {
    @Value.Parameter
    public abstract ImploderAttachment getImploderAttachment();

    public String getResource() {
        return this.getImploderAttachment().getLeftToken().getFilename();
    }

    public IToken getLeftToken() {
        return this.getImploderAttachment().getLeftToken();
    }

    public IToken getRightToken() {
        return this.getImploderAttachment().getRightToken();
    }

    public ITerm put(ITerm term) {
        ImmutableClassToInstanceMap.Builder attachments = ImmutableClassToInstanceMap.builder();
        term.getAttachments().entrySet().stream().filter(e -> !TermOrigin.class.equals(e.getKey())).forEach(e -> attachments.put((Class)e.getKey(), e.getValue()));
        attachments.put(TermOrigin.class, (Object)((TermOrigin)this));
        return term.withAttachments((ImmutableClassToInstanceMap<Object>)attachments.build());
    }

    public String toString() {
        IToken token = this.getImploderAttachment().getLeftToken();
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(token.getFilename());
        sb.append(":");
        sb.append(token.getLine());
        sb.append(",");
        sb.append(token.getColumn());
        return sb.toString();
    }

    public static TermOrigin of(String resource) {
        return TermOrigin.of(ImploderAttachment.createCompactPositionAttachment(resource, 0, 0, 0, 0));
    }

    public static Optional<TermOrigin> get(ITerm term) {
        return ATermOrigin.get(term.getAttachments());
    }

    public static ITerm copy(ITerm src, ITerm dst) {
        return ATermOrigin.get(src).map(o -> o.put(dst)).orElse(dst);
    }

    public static Optional<TermOrigin> get(ClassToInstanceMap<Object> attachments) {
        return Optional.ofNullable((TermOrigin)attachments.getInstance(TermOrigin.class));
    }

    public static Optional<TermOrigin> get(IStrategoTerm term) {
        return Optional.ofNullable(ImploderAttachment.get(OriginAttachment.tryGetOrigin(term))).map(ia -> TermOrigin.of(ia));
    }

    public static void copy(IStrategoTerm src, IStrategoTerm dst) {
        ATermOrigin.get(src).ifPresent(o -> o.put(dst));
    }

    public void put(IStrategoTerm term) {
        term.putAttachment(this.getImploderAttachment());
    }
}

