/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.HashMap;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;

public final class PlaceholderVarMap {
    private final String resourceName;
    private final HashMap<TermVarWrapper, IApplTerm> varToPlhdr = new HashMap();
    private final HashMap<IApplTerm, TermVarWrapper> plhdrToVar = new HashMap();

    public PlaceholderVarMap(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean add(ITermVar termVar, IApplTerm placeholderTerm) {
        IApplTerm oldPlaceholderTerm = this.varToPlhdr.put(new TermVarWrapper(termVar), placeholderTerm);
        TermVarWrapper oldTermVar = this.plhdrToVar.put(placeholderTerm, new TermVarWrapper(termVar));
        boolean replacedAnything = false;
        if (oldPlaceholderTerm != null && oldPlaceholderTerm != placeholderTerm) {
            this.varToPlhdr.remove(oldTermVar);
            replacedAnything = true;
        }
        if (oldTermVar != null && oldTermVar.termVar != termVar) {
            this.plhdrToVar.remove(oldPlaceholderTerm);
            replacedAnything = true;
        }
        assert (this.plhdrToVar.size() == this.varToPlhdr.size());
        return !replacedAnything;
    }

    @Nullable
    public ITermVar getVar(IApplTerm placeholderTerm) {
        TermVarWrapper termVarWrapper = this.plhdrToVar.get(placeholderTerm);
        return termVarWrapper != null ? termVarWrapper.termVar : null;
    }

    @Nullable
    public IApplTerm getPlaceholder(ITermVar varTerm) {
        return this.varToPlhdr.get(new TermVarWrapper(varTerm));
    }

    public boolean hasVarWithName(String name) {
        return this.varToPlhdr.keySet().stream().anyMatch(v -> ((TermVarWrapper)v).termVar.getName().equals(name));
    }

    public ITermVar addPlaceholderMapping(IApplTerm placeholderTerm) {
        ITermVar termVar = this.getVar(placeholderTerm);
        if (termVar == null) {
            String newVarName = this.generateName(placeholderTerm);
            termVar = TermBuild.B.newVar(this.resourceName, newVarName);
            boolean unique = this.add(termVar, placeholderTerm);
            assert (unique) : "Apparently the added term variable and/or placeholder was not unique.";
        }
        return termVar;
    }

    private String generateName(IApplTerm placeholderTerm) {
        String prefix = "$" + placeholderTerm.getOp().substring(0, placeholderTerm.getOp().length() - "-Plhdr".length());
        int index = 0;
        String name = String.valueOf(prefix) + index;
        while (this.hasVarWithName(name)) {
            name = String.valueOf(prefix) + ++index;
        }
        return name;
    }

    private static class TermVarWrapper {
        private final ITermVar termVar;

        private TermVarWrapper(ITermVar termVar) {
            this.termVar = termVar;
        }

        public int hashCode() {
            return this.termVar.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TermVarWrapper)) {
                return false;
            }
            return this.termVar.equals(((TermVarWrapper)obj).termVar, true);
        }

        public String toString() {
            return this.termVar.toString();
        }
    }
}

