/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.TermUtils;

public final class StrategoTermIndices {
    private static final String OP = "TermIndex";
    private static final int ARITY = 2;

    private StrategoTermIndices() {
    }

    public static IStrategoTerm index(IStrategoTerm term, String resource, ITermFactory termFactory) {
        return new Indexer(resource, termFactory).index(term);
    }

    public static IStrategoTerm erase(IStrategoTerm term, ITermFactory termFactory) {
        return new Eraser(termFactory).erase(term);
    }

    public static Optional<TermIndex> get(IStrategoTerm term) {
        for (IStrategoTerm anno : term.getAnnotations()) {
            Optional<TermIndex> index = StrategoTermIndices.match(anno);
            if (!index.isPresent()) continue;
            return index;
        }
        return Optional.empty();
    }

    public static <T extends IStrategoTerm> T put(TermIndex index, T term, ITermFactory factory) {
        IStrategoTerm result = factory.annotateTerm(term, factory.makeListCons(StrategoTermIndices.build(index, factory), StrategoTermIndices.removeFromAnnoList(term.getAnnotations(), factory)));
        return (T)result;
    }

    public static <T extends IStrategoTerm> T remove(T term, ITermFactory factory) {
        IStrategoTerm result = factory.annotateTerm(term, StrategoTermIndices.removeFromAnnoList(term.getAnnotations(), factory));
        return (T)result;
    }

    public static IStrategoTerm build(TermIndex index, ITermFactory factory) {
        IStrategoConstructor ctor = factory.makeConstructor(OP, 2);
        IStrategoAppl indexTerm = factory.makeAppl(ctor, factory.makeString(index.getResource()), factory.makeInt(index.getId()));
        TermOrigin.get(index).ifPresent(o -> o.put(indexTerm));
        return indexTerm;
    }

    public static Optional<TermIndex> match(IStrategoTerm term) {
        if (!TermUtils.isAppl(term, OP, 2)) {
            return Optional.empty();
        }
        IStrategoTerm resourceTerm = term.getSubterm(0);
        IStrategoTerm idTerm = term.getSubterm(1);
        TermIndex index1 = TermIndex.of(TermUtils.toJavaString(resourceTerm), TermUtils.toJavaInt(idTerm));
        TermIndex index2 = (TermIndex)TermOrigin.get(term).map(o -> o.put(index1)).orElse(index1);
        return Optional.of(index2);
    }

    private static IStrategoList removeFromAnnoList(IStrategoList list, ITermFactory factory) {
        return factory.makeList(Arrays.asList(list.getAllSubterms()).stream().filter(term -> !StrategoTermIndices.match(term).isPresent()).collect(Collectors.toList()));
    }

    private static class Eraser {
        private final ITermFactory termFactory;

        Eraser(ITermFactory termFactory) {
            this.termFactory = termFactory;
        }

        private IStrategoTerm erase(IStrategoTerm term) {
            IStrategoTerm result = StrategoTerms.match(term, StrategoTerms.cases(appl -> this.termFactory.makeAppl(appl.getConstructor(), this.erase(appl.getAllSubterms()), appl.getAnnotations()), tuple -> this.termFactory.makeTuple(this.erase(tuple.getAllSubterms()), tuple.getAnnotations()), list -> this.erase((IStrategoList)list), integer -> this.termFactory.annotateTerm(this.termFactory.makeInt(integer.intValue()), integer.getAnnotations()), real -> this.termFactory.annotateTerm(this.termFactory.makeReal(real.realValue()), real.getAnnotations()), string -> this.termFactory.annotateTerm(this.termFactory.makeString(string.stringValue()), string.getAnnotations()), blob -> new StrategoBlob(blob.value())));
            this.termFactory.copyAttachments(term, result);
            result = StrategoTermIndices.remove(result, this.termFactory);
            assert (!StrategoTermIndices.get(result).isPresent());
            return result;
        }

        private IStrategoList erase(IStrategoList list) {
            IStrategoList result = list.isEmpty() ? this.termFactory.makeList(TermFactory.EMPTY_TERM_ARRAY, list.getAnnotations()) : this.termFactory.makeListCons(this.erase(list.head()), this.erase(list.tail()), list.getAnnotations());
            this.termFactory.copyAttachments(list, result);
            result = StrategoTermIndices.remove(result, this.termFactory);
            assert (!StrategoTermIndices.get(result).isPresent());
            return result;
        }

        private IStrategoTerm[] erase(IStrategoTerm[] terms) {
            return (IStrategoTerm[])Arrays.asList(terms).stream().map(this::erase).toArray(IStrategoTerm[]::new);
        }
    }

    private static class Indexer {
        private final String resource;
        private final ITermFactory termFactory;
        private int currentId = 0;

        Indexer(String resource, ITermFactory termFactory) {
            this.resource = resource;
            this.termFactory = termFactory;
        }

        private IStrategoTerm index(IStrategoTerm term) {
            IStrategoTerm result = StrategoTerms.match(term, StrategoTerms.cases(appl -> this.termFactory.makeAppl(appl.getConstructor(), this.index(appl.getAllSubterms()), appl.getAnnotations()), tuple -> this.termFactory.makeTuple(this.index(tuple.getAllSubterms()), tuple.getAnnotations()), list -> this.index((IStrategoList)list), integer -> this.termFactory.annotateTerm(this.termFactory.makeInt(integer.intValue()), integer.getAnnotations()), real -> this.termFactory.annotateTerm(this.termFactory.makeReal(real.realValue()), real.getAnnotations()), string -> this.termFactory.annotateTerm(this.termFactory.makeString(string.stringValue()), string.getAnnotations()), blob -> new StrategoBlob(blob.value())));
            this.termFactory.copyAttachments(term, result);
            TermIndex index1 = TermIndex.of(this.resource, ++this.currentId);
            TermIndex index2 = (TermIndex)TermOrigin.get(term).map(o -> o.put(index1)).orElse(index1);
            result = StrategoTermIndices.put(index2, result, this.termFactory);
            return result;
        }

        private IStrategoList index(IStrategoList list) {
            IStrategoList result = list.isEmpty() ? this.termFactory.makeList(TermFactory.EMPTY_TERM_ARRAY, list.getAnnotations()) : this.termFactory.makeListCons(this.index(list.head()), this.index(list.tail()), list.getAnnotations());
            this.termFactory.copyAttachments(list, result);
            TermIndex index1 = TermIndex.of(this.resource, ++this.currentId);
            TermIndex index2 = (TermIndex)TermOrigin.get(list).map(o -> o.put(index1)).orElse(index1);
            result = StrategoTermIndices.put(index2, result, this.termFactory);
            return result;
        }

        private IStrategoTerm[] index(IStrategoTerm[] terms) {
            return (IStrategoTerm[])Arrays.asList(terms).stream().map(this::index).toArray(IStrategoTerm[]::new);
        }
    }
}

