/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.AStrategoAnnotations;
import mb.nabl2.terms.stratego.StrategoAnnotations;
import mb.nabl2.terms.stratego.StrategoBlob;
import mb.nabl2.terms.stratego.StrategoTermIndices;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import org.metaborg.util.functions.Function1;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class StrategoTerms {
    private final ITermFactory termFactory;

    public StrategoTerms(ITermFactory termFactory) {
        this.termFactory = termFactory;
    }

    public IStrategoTerm toStratego(ITerm term) {
        IStrategoTerm strategoTerm = term.match(Terms.cases(appl -> {
            List<IStrategoTerm> args = appl.getArgs().stream().map(arg -> this.toStratego((ITerm)arg)).collect(Collectors.toList());
            IStrategoTerm[] argArray = args.toArray(new IStrategoTerm[args.size()]);
            return appl.getOp().equals("") ? this.termFactory.makeTuple(argArray) : this.termFactory.makeAppl(this.termFactory.makeConstructor(appl.getOp(), appl.getArity()), argArray);
        }, list -> this.toStrategoList((IListTerm)list), string -> this.termFactory.makeString(string.getValue()), integer -> this.termFactory.makeInt(integer.getValue()), blob -> new StrategoBlob(blob.getValue()), var -> this.termFactory.makeAppl("nabl2.Var", this.termFactory.makeString(var.getResource()), this.termFactory.makeString(var.getName()))));
        switch (strategoTerm.getType()) {
            case LIST: 
            case BLOB: {
                break;
            }
            default: {
                strategoTerm = this.putAttachments(strategoTerm, term.getAttachments());
            }
        }
        return strategoTerm;
    }

    private IStrategoTerm toStrategoList(IListTerm list) {
        LinkedList terms = Lists.newLinkedList();
        LinkedList attachments = Lists.newLinkedList();
        while (list != null) {
            attachments.push(list.getAttachments());
            list = list.match(ListTerms.cases(cons -> {
                terms.push(this.toStratego(cons.getHead()));
                return cons.getTail();
            }, nil -> null, var -> {
                throw new IllegalArgumentException("Cannot convert specialized terms to Stratego.");
            }));
        }
        IStrategoList strategoList = this.termFactory.makeList();
        this.putAttachments(strategoList, (ImmutableClassToInstanceMap<Object>)((ImmutableClassToInstanceMap)attachments.pop()));
        while (!terms.isEmpty()) {
            strategoList = this.termFactory.makeListCons((IStrategoTerm)terms.pop(), strategoList);
            this.putAttachments(strategoList, (ImmutableClassToInstanceMap<Object>)((ImmutableClassToInstanceMap)attachments.pop()));
        }
        return strategoList;
    }

    private <T extends IStrategoTerm> T putAttachments(T term, ImmutableClassToInstanceMap<Object> attachments) {
        AStrategoAnnotations annotations;
        Optional<TermIndex> index;
        Optional<TermOrigin> origin = TermOrigin.get(attachments);
        if (origin.isPresent()) {
            origin.get().put((IStrategoTerm)term);
        }
        if ((index = TermIndex.get(attachments)).isPresent()) {
            term = StrategoTermIndices.put(index.get(), term, this.termFactory);
        }
        if ((annotations = (AStrategoAnnotations)attachments.getInstance(AStrategoAnnotations.class)) != null) {
            IStrategoTerm result = this.termFactory.copyAttachments((IStrategoTerm)term, this.termFactory.annotateTerm((IStrategoTerm)term, this.termFactory.makeList(annotations.getAnnotationList())));
            term = result;
        }
        return term;
    }

    public ITerm fromStratego(IStrategoTerm sterm) {
        ImmutableClassToInstanceMap<Object> attachments = StrategoTerms.getAttachments(sterm);
        ITerm term = StrategoTerms.match(sterm, StrategoTerms.cases(appl -> {
            List args = (List)Arrays.asList(appl.getAllSubterms()).stream().map(this::fromStratego).collect(ImmutableList.toImmutableList());
            return TermBuild.B.newAppl(appl.getConstructor().getName(), args, attachments);
        }, tuple -> {
            List args = (List)Arrays.asList(tuple.getAllSubterms()).stream().map(this::fromStratego).collect(ImmutableList.toImmutableList());
            return TermBuild.B.newTuple(args, attachments);
        }, this::fromStrategoList, integer -> TermBuild.B.newInt(integer.intValue(), attachments), real -> {
            throw new IllegalArgumentException("Real values are not supported.");
        }, string -> TermBuild.B.newString(string.stringValue(), attachments), blob -> TermBuild.B.newBlob(blob.value())));
        return term;
    }

    private IListTerm fromStrategoList(IStrategoList list) {
        LinkedList terms = Lists.newLinkedList();
        LinkedList attachments = Lists.newLinkedList();
        while (!list.isEmpty()) {
            terms.add(this.fromStratego(list.head()));
            attachments.push(StrategoTerms.getAttachments(list));
            list = list.tail();
        }
        attachments.add(StrategoTerms.getAttachments(list));
        return TermBuild.B.newList(terms, attachments);
    }

    public static ImmutableClassToInstanceMap<Object> getAttachments(IStrategoTerm term) {
        ImmutableClassToInstanceMap.Builder b = ImmutableClassToInstanceMap.builder();
        TermOrigin.get(term).ifPresent(origin -> b.put(TermOrigin.class, origin));
        StrategoTermIndices.get(term).ifPresent(termIndex -> b.put(TermIndex.class, termIndex));
        b.put(AStrategoAnnotations.class, (Object)StrategoAnnotations.of(term.getAnnotations()));
        return b.build();
    }

    public static <T> T match(IStrategoTerm term, ICases<T> cases) {
        switch (term.getType()) {
            case APPL: {
                return cases.caseAppl((IStrategoAppl)term);
            }
            case LIST: {
                return cases.caseList((IStrategoList)term);
            }
            case TUPLE: {
                return cases.caseTuple((IStrategoTuple)term);
            }
            case INT: {
                return cases.caseInt((IStrategoInt)term);
            }
            case REAL: {
                return cases.caseReal((IStrategoReal)term);
            }
            case STRING: {
                return cases.caseString((IStrategoString)term);
            }
            case BLOB: {
                if (term instanceof StrategoBlob) {
                    StrategoBlob blob = (StrategoBlob)term;
                    return cases.caseBlob(blob);
                }
                throw new IllegalArgumentException("Unsupported Stratego blob type " + term.getClass());
            }
        }
        throw new IllegalArgumentException("Unsupported Stratego term type " + (Object)((Object)term.getType()));
    }

    public static <T> ICases<T> cases(final Function1<IStrategoAppl, T> onAppl, final Function1<IStrategoTuple, T> onTuple, final Function1<IStrategoList, T> onList, final Function1<IStrategoInt, T> onInt, final Function1<IStrategoReal, T> onReal, final Function1<IStrategoString, T> onString, final Function1<StrategoBlob, T> onBlob) {
        return new ICases<T>(){

            @Override
            public T caseAppl(IStrategoAppl term) {
                return onAppl.apply(term);
            }

            @Override
            public T caseTuple(IStrategoTuple term) {
                return onTuple.apply(term);
            }

            @Override
            public T caseList(IStrategoList term) {
                return onList.apply(term);
            }

            @Override
            public T caseInt(IStrategoInt term) {
                return onInt.apply(term);
            }

            @Override
            public T caseReal(IStrategoReal term) {
                return onReal.apply(term);
            }

            @Override
            public T caseString(IStrategoString term) {
                return onString.apply(term);
            }

            @Override
            public T caseBlob(StrategoBlob term) {
                return onBlob.apply(term);
            }
        };
    }

    @FunctionalInterface
    public static interface Attacher {
        public <T> void put(Class<T> var1, T var2);
    }

    public static interface ICases<T> {
        public T caseAppl(IStrategoAppl var1);

        public T caseList(IStrategoList var1);

        public T caseTuple(IStrategoTuple var1);

        public T caseInt(IStrategoInt var1);

        public T caseReal(IStrategoReal var1);

        public T caseString(IStrategoString var1);

        public T caseBlob(StrategoBlob var1);
    }
}

