/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMultiset;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.ATermIndex;

public final class TermIndex
extends ATermIndex
implements Serializable {
    private final ImmutableClassToInstanceMap<Object> attachments;
    private final String resource;
    private final int id;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ARITY_LAZY_INIT_BIT = 1L;
    private transient int arity;
    private static final long GROUND_LAZY_INIT_BIT = 2L;
    private transient boolean ground;
    private static final long VARS_LAZY_INIT_BIT = 4L;
    private transient ImmutableMultiset<ITermVar> vars;
    private static final long ARGS_LAZY_INIT_BIT = 8L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private TermIndex(String resource, int id) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.id = id;
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private TermIndex(ImmutableClassToInstanceMap<Object> attachments, String resource, int id) {
        this.attachments = attachments;
        this.resource = resource;
        this.id = id;
        this.hashCode = super.hashCode();
    }

    @Override
    public ImmutableClassToInstanceMap<Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final TermIndex withAttachments(ImmutableClassToInstanceMap<Object> value) {
        if (this.attachments == value) {
            return this;
        }
        ImmutableClassToInstanceMap<Object> newValue = Objects.requireNonNull(value, "attachments");
        return new TermIndex(newValue, this.resource, this.id);
    }

    public final TermIndex withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new TermIndex(this.attachments, newValue, this.id);
    }

    public final TermIndex withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new TermIndex(this.attachments, this.resource, value);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArity() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.arity = super.getArity();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGround() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.ground = super.isGround();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.ground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMultiset<ITermVar> getVars() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.vars = Objects.requireNonNull(super.getVars(), "vars");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            TermIndex termIndex = this;
            synchronized (termIndex) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.args;
    }

    public static TermIndex of(String resource, int id) {
        return new TermIndex(resource, id);
    }

    public static TermIndex copyOf(ATermIndex instance) {
        if (instance instanceof TermIndex) {
            return (TermIndex)instance;
        }
        return TermIndex.of(instance.getResource(), instance.getId()).withAttachments((ImmutableClassToInstanceMap)instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new TermIndex(this.attachments, this.resource, this.id);
    }
}

