/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.CapsuleUtil;
import org.metaborg.util.iterators.Iterables2;

public abstract class PersistentSubstitution
implements ISubstitution {
    protected abstract io.usethesource.capsule.Map<ITermVar, ITerm> subst();

    @Override
    public boolean isEmpty() {
        return this.subst().isEmpty();
    }

    @Override
    public boolean contains(ITermVar var) {
        return this.subst().containsKey((Object)var);
    }

    @Override
    public Set<ITermVar> varSet() {
        return this.subst().keySet();
    }

    @Override
    public Set<Map.Entry<ITermVar, ITerm>> entrySet() {
        return this.subst().entrySet();
    }

    @Override
    public ITerm apply(ITerm term) {
        return term.match(Terms.cases(appl -> {
            List args = (List)appl.getArgs().stream().map(this::apply).collect(ImmutableList.toImmutableList());
            return TermBuild.B.newAppl(appl.getOp(), args, appl.getAttachments());
        }, list -> this.apply((IListTerm)list), string -> string, integer -> integer, blob -> blob, var -> this.apply((ITermVar)var)));
    }

    private IListTerm apply(IListTerm list) {
        return list.match(ListTerms.cases(cons -> TermBuild.B.newCons(this.apply(cons.getHead()), this.apply(cons.getTail()), cons.getAttachments()), nil -> nil, var -> (IListTerm)this.apply((ITermVar)var)));
    }

    private ITerm apply(ITermVar var) {
        return (ITerm)this.subst().getOrDefault((Object)var, (Object)var);
    }

    public String toString() {
        return this.subst().toString();
    }

    public static class Immutable
    extends PersistentSubstitution
    implements ISubstitution.Immutable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map.Immutable<ITermVar, ITerm> subst;

        public Immutable(Map.Immutable<ITermVar, ITerm> sub) {
            this.subst = sub;
        }

        @Override
        protected io.usethesource.capsule.Map<ITermVar, ITerm> subst() {
            return this.subst;
        }

        @Override
        public ISubstitution.Immutable put(ITermVar var, ITerm term) {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)this.subst.__put((Object)var, (Object)term));
        }

        @Override
        public ISubstitution.Immutable remove(ITermVar var) {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)this.subst.__remove((Object)var));
        }

        @Override
        public ISubstitution.Immutable removeAll(Iterable<ITermVar> vars) {
            Map.Transient subst = this.subst.asTransient();
            Iterables2.stream(vars).forEach(arg_0 -> ((Map.Transient)subst).__remove(arg_0));
            return new Immutable((Map.Immutable<ITermVar, ITerm>)subst.freeze());
        }

        @Override
        public ISubstitution.Immutable compose(ISubstitution.Immutable other) {
            Map.Transient subst = this.subst.asTransient();
            CapsuleUtil.updateValues(subst, (v, t) -> other.apply((ITerm)t));
            other.removeAll(subst.keySet()).entrySet().forEach(e -> {
                Object object = subst.__put((Object)((ITermVar)e.getKey()), (Object)((ITerm)e.getValue()));
            });
            return new Immutable((Map.Immutable<ITermVar, ITerm>)subst.freeze());
        }

        @Override
        public ISubstitution.Immutable compose(ITermVar var, ITerm term) {
            return this.compose(Immutable.of(var, term));
        }

        @Override
        public ISubstitution.Transient melt() {
            return new Transient((Map.Transient<ITermVar, ITerm>)this.subst.asTransient());
        }

        public static ISubstitution.Immutable of() {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)Map.Immutable.of());
        }

        public static ISubstitution.Immutable of(ITermVar var, ITerm term) {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)Map.Immutable.of((Object)var, (Object)term));
        }

        public static ISubstitution.Immutable of(Map<ITermVar, ? extends ITerm> subst) {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)Map.Immutable.of().__putAll(subst));
        }
    }

    public static class Transient
    extends PersistentSubstitution
    implements ISubstitution.Transient {
        private Map.Transient<ITermVar, ITerm> subst;

        public Transient(Map.Transient<ITermVar, ITerm> subst) {
            this.subst = subst;
        }

        @Override
        protected io.usethesource.capsule.Map<ITermVar, ITerm> subst() {
            return this.subst;
        }

        @Override
        public void put(ITermVar var, ITerm term) {
            this.subst.__put((Object)var, (Object)term);
        }

        @Override
        public void remove(ITermVar var) {
            this.subst.__remove((Object)var);
        }

        @Override
        public void removeAll(Iterable<ITermVar> vars) {
            Iterables2.stream(vars).forEach(arg_0 -> this.subst.remove(arg_0));
        }

        @Override
        public void compose(ISubstitution.Immutable other) {
            CapsuleUtil.updateValues(this.subst, (v, t) -> other.apply((ITerm)t));
            other.removeAll(this.subst.keySet()).entrySet().forEach(e -> {
                Object object = this.subst.__put((Object)((ITermVar)e.getKey()), (Object)((ITerm)e.getValue()));
            });
        }

        @Override
        public void compose(ITermVar var, ITerm term) {
            this.compose(Immutable.of(var, term));
        }

        @Override
        public ISubstitution.Immutable freeze() {
            return new Immutable((Map.Immutable<ITermVar, ITerm>)this.subst.freeze());
        }

        public static ISubstitution.Transient of() {
            return new Transient((Map.Transient<ITermVar, ITerm>)Map.Transient.of());
        }
    }
}

