/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.IRenaming;

public class Renaming
implements IRenaming {
    private final BiMap<ITermVar, ITermVar> renaming;

    private Renaming(BiMap<ITermVar, ITermVar> renaming) {
        this.renaming = renaming;
    }

    @Override
    public Set<ITermVar> keySet() {
        return this.renaming.keySet();
    }

    @Override
    public Set<ITermVar> valueSet() {
        return this.renaming.values();
    }

    @Override
    public ITermVar rename(ITermVar var) {
        return (ITermVar)this.renaming.getOrDefault((Object)var, (Object)var);
    }

    @Override
    public ITerm apply(ITerm term) {
        return term.match(Terms.cases(appl -> {
            List args = (List)appl.getArgs().stream().map(this::apply).collect(ImmutableList.toImmutableList());
            return TermBuild.B.newAppl(appl.getOp(), args, appl.getAttachments());
        }, list -> this.apply((IListTerm)list), string -> string, integer -> integer, blob -> blob, var -> this.rename((ITermVar)var)));
    }

    private IListTerm apply(IListTerm list) {
        return list.match(ListTerms.cases(cons -> TermBuild.B.newCons(this.apply(cons.getHead()), this.apply(cons.getTail()), cons.getAttachments()), nil -> nil, var -> this.rename((ITermVar)var)));
    }

    public String toString() {
        return this.renaming.entrySet().stream().map(e -> e.getKey() + " |-> " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Renaming(BiMap biMap, Renaming renaming) {
        this((BiMap<ITermVar, ITermVar>)biMap);
    }

    public static class Builder {
        private final BiMap<ITermVar, ITermVar> renaming = HashBiMap.create();

        private Builder() {
        }

        public boolean containsKey(ITermVar var) {
            return this.renaming.containsKey((Object)var);
        }

        public boolean containsValue(ITermVar var) {
            return this.renaming.containsValue((Object)var);
        }

        public Builder put(ITermVar v1, ITermVar v2) {
            this.renaming.put((Object)v1, (Object)v2);
            return this;
        }

        public Renaming build() {
            return new Renaming(this.renaming, null);
        }
    }
}

