/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.u;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.BaseUnifier;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.CapsuleUtil;
import mb.nabl2.util.Tuple2;
import org.metaborg.util.Ref;

public abstract class PersistentUnifier
extends BaseUnifier
implements IUnifier,
Serializable {
    private static final long serialVersionUID = 42L;

    protected static ITermVar findRep(ITermVar var, Map.Transient<ITermVar, ITermVar> reps) {
        ITermVar rep = (ITermVar)reps.get((Object)var);
        if (rep == null) {
            return var;
        }
        rep = PersistentUnifier.findRep(rep, reps);
        reps.__put((Object)var, (Object)rep);
        return rep;
    }

    public static class Immutable
    extends PersistentUnifier
    implements IUnifier.Immutable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final boolean finite;
        private final Ref<Map.Immutable<ITermVar, ITermVar>> reps;
        private final Map.Immutable<ITermVar, Integer> ranks;
        private final Map.Immutable<ITermVar, ITerm> terms;

        public Immutable(boolean finite, Map.Immutable<ITermVar, ITermVar> reps, Map.Immutable<ITermVar, Integer> ranks, Map.Immutable<ITermVar, ITerm> terms) {
            this.finite = finite;
            this.reps = new Ref<Map.Immutable<ITermVar, ITermVar>>(reps);
            this.ranks = ranks;
            this.terms = terms;
        }

        @Override
        public boolean isFinite() {
            return this.finite;
        }

        @Override
        protected Map.Immutable<ITermVar, ITermVar> reps() {
            return this.reps.get();
        }

        @Override
        protected Map.Immutable<ITermVar, ITerm> terms() {
            return this.terms;
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            Map.Transient reps = this.reps.get().asTransient();
            ITermVar rep = Immutable.findRep(var, (Map.Transient<ITermVar, ITermVar>)reps);
            this.reps.set((Map.Immutable<ITermVar, ITermVar>)reps.freeze());
            return rep;
        }

        public Optional<IUnifier.Result<IUnifier.Immutable>> unify(ITerm left, ITerm right) throws OccursException {
            return new Unify(this, left, right).apply();
        }

        public Optional<IUnifier.Result<IUnifier.Immutable>> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities) throws OccursException {
            return new Unify(this, equalities).apply();
        }

        public Optional<IUnifier.Result<IUnifier.Immutable>> unify(IUnifier other) throws OccursException {
            return new Unify(this, other).apply();
        }

        public Optional<IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(IUnifier.Result::result);
            }
            catch (OccursException e) {
                return Optional.empty();
            }
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> retain(ITermVar var) {
            return this.retainAll((Iterable<ITermVar>)Set.Immutable.of((Object)var));
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> retainAll(Iterable<ITermVar> vars) {
            return this.removeAll((Iterable<ITermVar>)Set.Immutable.subtract(this.varSet(), CapsuleUtil.toSet(vars)));
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> remove(ITermVar var) {
            return this.removeAll((Iterable<ITermVar>)Set.Immutable.of((Object)var));
        }

        @Override
        public IUnifier.Result<ISubstitution.Immutable> removeAll(Iterable<ITermVar> vars) {
            return new RemoveAll(this, vars).apply();
        }

        @Override
        public IUnifier.Transient melt() {
            return new BaseUnifier.Transient(this);
        }

        public static IUnifier.Immutable of() {
            return Immutable.of(true);
        }

        public static IUnifier.Immutable of(boolean finite) {
            return new Immutable(finite, (Map.Immutable<ITermVar, ITermVar>)Map.Immutable.of(), (Map.Immutable<ITermVar, Integer>)Map.Immutable.of(), (Map.Immutable<ITermVar, ITerm>)Map.Immutable.of());
        }

        private static class RemoveAll
        extends Transient {
            private final Set.Immutable<ITermVar> vars;

            public RemoveAll(Immutable unifier, Iterable<ITermVar> vars) {
                super(unifier);
                this.vars = CapsuleUtil.toSet(vars);
            }

            public IUnifier.Result<ISubstitution.Immutable> apply() {
                ISubstitution.Immutable subst = this.removeAll();
                Immutable newUnifier = this.freeze();
                return new BaseUnifier.ImmutableResult<ISubstitution.Immutable>(subst, newUnifier);
            }

            private ISubstitution.Immutable removeAll() {
                ITermVar rep;
                ISubstitution.Transient subst = PersistentSubstitution.Transient.of();
                if (this.vars.isEmpty()) {
                    return subst.freeze();
                }
                ListMultimap<ITermVar, ITermVar> invReps = this.getInvReps();
                for (ITermVar var : this.vars) {
                    ITerm term;
                    rep = this.removeRep(var);
                    if (rep != null) {
                        invReps.remove((Object)rep, (Object)var);
                        subst.compose(var, rep);
                        for (ITermVar notRep : invReps.get((Object)var)) {
                            this.putRep(notRep, rep);
                            invReps.put((Object)rep, (Object)notRep);
                        }
                        continue;
                    }
                    List newReps = invReps.removeAll((Object)var);
                    if (!newReps.isEmpty()) {
                        rep = (ITermVar)newReps.stream().max((r1, r2) -> Integer.compare(this.getRank((ITermVar)r1), this.getRank((ITermVar)r2))).get();
                        this.removeRep(rep);
                        invReps.remove((Object)rep, (Object)var);
                        subst.compose(var, rep);
                        for (ITermVar notRep : newReps) {
                            if (notRep.equals(rep)) continue;
                            this.putRep(notRep, rep);
                            invReps.put((Object)rep, (Object)notRep);
                        }
                        term = this.removeTerm(var);
                        if (term == null) continue;
                        this.putTerm(rep, term);
                        continue;
                    }
                    term = this.removeTerm(var);
                    if (term == null) continue;
                    subst.compose(var, term);
                }
                for (Map.Entry<ITermVar, ITerm> entry : this.termEntries()) {
                    rep = entry.getKey();
                    ITerm term = entry.getValue();
                    this.putTerm(rep, subst.apply(term));
                }
                return subst.freeze();
            }
        }

        private static class Unify
        extends Transient {
            private final Deque<Map.Entry<ITerm, ITerm>> worklist = Lists.newLinkedList();
            private final List<ITermVar> result = Lists.newArrayList();

            public Unify(Immutable unifier, ITerm left, ITerm right) {
                super(unifier);
                this.worklist.push(Tuple2.of(left, right));
            }

            public Unify(Immutable unifier, Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities) {
                super(unifier);
                equalities.forEach(e -> this.worklist.push(Tuple2.of(e)));
            }

            public Unify(Immutable unifier, IUnifier other) {
                super(unifier);
                other.varSet().forEach(v -> this.worklist.push(Tuple2.of(v, other.findTerm((ITerm)v))));
            }

            public Optional<IUnifier.Result<IUnifier.Immutable>> apply() throws OccursException {
                ImmutableSet cyclicVars;
                while (!this.worklist.isEmpty()) {
                    Map.Entry<ITerm, ITerm> work = this.worklist.pop();
                    if (this.unifyTerms(work.getKey(), work.getValue())) continue;
                    return Optional.empty();
                }
                Immutable unifier = this.freeze();
                if (this.finite && !(cyclicVars = (ImmutableSet)this.result.stream().filter(v -> unifier.isCyclic((ITerm)v)).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
                    throw new OccursException((Iterable<ITermVar>)cyclicVars);
                }
                IUnifier.Immutable diffUnifier = this.diffUnifier(this.result);
                return Optional.of(new BaseUnifier.ImmutableResult<IUnifier.Immutable>(diffUnifier, unifier));
            }

            private boolean unifyTerms(ITerm left, ITerm right) {
                return left.match(Terms.cases(applLeft -> right.match(Terms.cases().appl(applRight -> {
                    if (applLeft.getArity() == applRight.getArity() && applLeft.getOp().equals(applRight.getOp()) && this.unifys(applLeft.getArgs(), applRight.getArgs())) {
                        return true;
                    }
                    return false;
                }).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)applLeft)).otherwise(t -> false)), listLeft -> right.match(Terms.cases().list(listRight -> this.unifyLists((IListTerm)listLeft, (IListTerm)listRight)).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)listLeft)).otherwise(t -> false)), stringLeft -> right.match(Terms.cases().string(stringRight -> stringLeft.getValue().equals(stringRight.getValue())).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)stringLeft)).otherwise(t -> false)), integerLeft -> right.match(Terms.cases().integer(integerRight -> {
                    if (integerLeft.getValue() == integerRight.getValue()) {
                        return true;
                    }
                    return false;
                }).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)integerLeft)).otherwise(t -> false)), blobLeft -> right.match(Terms.cases().blob(blobRight -> blobLeft.getValue().equals(blobRight.getValue())).var(varRight -> this.unifyTerms((ITerm)varRight, (ITerm)blobLeft)).otherwise(t -> false)), varLeft -> right.match(Terms.cases().var(varRight -> this.unifyVars((ITermVar)varLeft, (ITermVar)varRight)).otherwise(termRight -> this.unifyVarTerm((ITermVar)varLeft, (ITerm)termRight)))));
            }

            private boolean unifyLists(IListTerm left, IListTerm right) {
                return left.match(ListTerms.cases(consLeft -> right.match(ListTerms.cases().cons(consRight -> {
                    this.worklist.push(Tuple2.of(consLeft.getHead(), consRight.getHead()));
                    this.worklist.push(Tuple2.of(consLeft.getTail(), consRight.getTail()));
                    return true;
                }).var(varRight -> this.unifyLists((IListTerm)varRight, (IListTerm)consLeft)).otherwise(l -> false)), nilLeft -> right.match(ListTerms.cases().nil(nilRight -> true).var(varRight -> this.unifyVarTerm((ITermVar)varRight, (ITerm)nilLeft)).otherwise(l -> false)), varLeft -> right.match(ListTerms.cases().var(varRight -> this.unifyVars((ITermVar)varLeft, (ITermVar)varRight)).otherwise(termRight -> this.unifyVarTerm((ITermVar)varLeft, (ITerm)termRight)))));
            }

            private boolean unifyVarTerm(ITermVar var, ITerm term) {
                ITermVar rep = this.findRep(var);
                if (term instanceof ITermVar) {
                    throw new IllegalStateException();
                }
                ITerm repTerm = this.getTerm(rep);
                if (repTerm != null) {
                    this.worklist.push(Tuple2.of(repTerm, term));
                } else {
                    this.putTerm(rep, term);
                    this.result.add(rep);
                }
                return true;
            }

            private boolean unifyVars(ITermVar left, ITermVar right) {
                int rightRank;
                ITermVar rightRep;
                ITermVar leftRep = this.findRep(left);
                if (leftRep.equals(rightRep = this.findRep(right))) {
                    return true;
                }
                int leftRank = Optional.ofNullable((Integer)this.ranks.__remove((Object)leftRep)).orElse(1);
                boolean swap = leftRank > (rightRank = Optional.ofNullable((Integer)this.ranks.__remove((Object)rightRep)).orElse(1).intValue());
                ITermVar var = swap ? rightRep : leftRep;
                ITermVar rep = swap ? leftRep : rightRep;
                this.ranks.__put((Object)rep, (Object)(leftRank + rightRank));
                this.putRep(var, rep);
                ITerm varTerm = this.removeTerm(var);
                if (varTerm != null) {
                    ITerm repTerm = this.getTerm(rep);
                    if (repTerm != null) {
                        this.worklist.push(Tuple2.of(varTerm, repTerm));
                    } else {
                        this.putTerm(rep, varTerm);
                        this.result.add(rep);
                    }
                } else {
                    this.result.add(var);
                }
                return true;
            }

            private boolean unifys(Iterable<ITerm> lefts, Iterable<ITerm> rights) {
                Iterator<ITerm> itLeft = lefts.iterator();
                Iterator<ITerm> itRight = rights.iterator();
                while (itLeft.hasNext()) {
                    if (!itRight.hasNext()) {
                        return false;
                    }
                    this.worklist.push(Tuple2.of(itLeft.next(), itRight.next()));
                }
                return !itRight.hasNext();
            }

            private IUnifier.Immutable diffUnifier(Collection<ITermVar> vars) {
                Transient diff = new Transient(this.finite);
                for (ITermVar var : vars) {
                    ITermVar rep = this.getRep(var);
                    if (rep != null) {
                        diff.putRep(var, rep);
                        continue;
                    }
                    ITerm term = this.getTerm(var);
                    if (term == null) continue;
                    diff.putTerm(var, term);
                }
                return diff.freeze();
            }
        }
    }

    static class Transient {
        protected final boolean finite;
        private final Map.Transient<ITermVar, ITermVar> reps;
        protected final Map.Transient<ITermVar, Integer> ranks;
        private final Map.Transient<ITermVar, ITerm> terms;

        Transient(boolean finite) {
            this(finite, (Map.Transient<ITermVar, ITermVar>)Map.Transient.of(), (Map.Transient<ITermVar, Integer>)Map.Transient.of(), (Map.Transient<ITermVar, ITerm>)Map.Transient.of());
        }

        Transient(Immutable unifier) {
            this(unifier.finite, (Map.Transient<ITermVar, ITermVar>)((Map.Immutable)unifier.reps.get()).asTransient(), (Map.Transient<ITermVar, Integer>)unifier.ranks.asTransient(), (Map.Transient<ITermVar, ITerm>)unifier.terms.asTransient());
        }

        Transient(boolean finite, Map.Transient<ITermVar, ITermVar> reps, Map.Transient<ITermVar, Integer> ranks, Map.Transient<ITermVar, ITerm> terms) {
            this.finite = finite;
            this.reps = reps;
            this.ranks = ranks;
            this.terms = terms;
        }

        protected Iterable<Map.Entry<ITermVar, ITermVar>> repEntries() {
            return this.reps.entrySet();
        }

        protected Iterable<Map.Entry<ITermVar, ITerm>> termEntries() {
            return this.terms.entrySet();
        }

        protected ITermVar findRep(ITermVar var) {
            return PersistentUnifier.findRep(var, this.reps);
        }

        protected ITermVar getRep(ITermVar var) {
            return (ITermVar)this.reps.get((Object)var);
        }

        protected ListMultimap<ITermVar, ITermVar> getInvReps() {
            LinkedListMultimap invReps = LinkedListMultimap.create();
            this.reps.forEach((arg_0, arg_1) -> Transient.lambda$0((ListMultimap)invReps, arg_0, arg_1));
            return invReps;
        }

        protected void putRep(ITermVar var, ITermVar rep) {
            this.reps.__put((Object)var, (Object)rep);
        }

        protected ITermVar removeRep(ITermVar var) {
            return (ITermVar)this.reps.__remove((Object)var);
        }

        protected ITerm getTerm(ITermVar rep) {
            return (ITerm)this.terms.get((Object)rep);
        }

        protected void putTerm(ITermVar rep, ITerm term) {
            this.terms.__put((Object)rep, (Object)term);
        }

        protected ITerm removeTerm(ITermVar rep) {
            return (ITerm)this.terms.__remove((Object)rep);
        }

        protected int getRank(ITermVar var) {
            return (Integer)this.ranks.getOrDefault((Object)var, (Object)1);
        }

        protected Immutable freeze() {
            Immutable unifier = new Immutable(this.finite, (Map.Immutable<ITermVar, ITermVar>)this.reps.freeze(), (Map.Immutable<ITermVar, Integer>)this.ranks.freeze(), (Map.Immutable<ITermVar, ITerm>)this.terms.freeze());
            return unifier;
        }

        private static /* synthetic */ void lambda$0(ListMultimap listMultimap, ITermVar var, ITermVar rep) {
            listMultimap.put((Object)rep, (Object)var);
        }
    }
}

