/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.ud;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.TermSize;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;

public abstract class BaseUniDisunifier
implements IUniDisunifier,
Serializable {
    private static final long serialVersionUID = 42L;

    protected abstract IUnifier.Immutable unifier();

    @Override
    public Map.Immutable<ITermVar, ITerm> equalityMap() {
        return this.unifier().equalityMap();
    }

    @Override
    public boolean isEmpty() {
        return this.unifier().isEmpty() && this.disequalities().isEmpty();
    }

    @Override
    public boolean contains(ITermVar var) {
        return this.unifier().contains(var);
    }

    @Override
    public Set.Immutable<ITermVar> varSet() {
        return this.unifier().varSet();
    }

    @Override
    public Set.Immutable<ITermVar> freeVarSet() {
        Set.Transient freeVarSet = this.unifier().freeVarSet().asTransient();
        this.disequalities().stream().flatMap(diseq -> diseq.freeVarSet().stream()).filter(v -> !this.unifier().contains((ITermVar)v)).forEach(arg_0 -> ((Set.Transient)freeVarSet).__insert(arg_0));
        return freeVarSet.freeze();
    }

    @Override
    public boolean isCyclic() {
        return this.unifier().isCyclic();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append(this.unifier());
        sb.append(";");
        boolean first = true;
        for (Diseq disequality : this.disequalities()) {
            sb.append(first ? " " : ", ");
            first = false;
            sb.append(disequality);
        }
        sb.append(first ? "}" : " }");
        return sb.toString();
    }

    @Override
    public boolean hasTerm(ITermVar var) {
        return this.unifier().hasTerm(var);
    }

    @Override
    public ITerm findTerm(ITerm term) {
        return this.unifier().findTerm(term);
    }

    @Override
    public ITerm findRecursive(ITerm term) {
        return this.unifier().findRecursive(term);
    }

    @Override
    public boolean isCyclic(ITerm term) {
        return this.unifier().isCyclic(term);
    }

    @Override
    public boolean isGround(ITerm term) {
        return this.unifier().isGround(term);
    }

    @Override
    public Set.Immutable<ITermVar> getVars(ITerm term) {
        return this.unifier().getVars(term);
    }

    @Override
    public TermSize size(ITerm term) {
        return this.unifier().size(term);
    }

    @Override
    public String toString(ITerm term) {
        return this.unifier().toString(term);
    }

    @Override
    public String toString(ITerm term, int n) {
        return this.unifier().toString(term, n);
    }

    protected static class ImmutableResult<T>
    implements IUniDisunifier.Result<T> {
        private final T result;
        private final IUniDisunifier.Immutable unifier;

        public ImmutableResult(T result, IUniDisunifier.Immutable unifier) {
            this.result = result;
            this.unifier = unifier;
        }

        @Override
        public T result() {
            return this.result;
        }

        @Override
        public IUniDisunifier.Immutable unifier() {
            return this.unifier;
        }
    }

    protected static class Transient
    implements IUniDisunifier.Transient {
        private IUniDisunifier.Immutable unifier;

        public Transient(IUniDisunifier.Immutable unifier) {
            this.unifier = unifier;
        }

        @Override
        public boolean isFinite() {
            return this.unifier.isFinite();
        }

        @Override
        public boolean isEmpty() {
            return this.unifier.isEmpty();
        }

        @Override
        public boolean contains(ITermVar var) {
            return this.unifier.contains(var);
        }

        @Override
        public Set.Immutable<ITermVar> varSet() {
            return this.unifier.varSet();
        }

        @Override
        public Set.Immutable<ITermVar> freeVarSet() {
            return this.unifier.freeVarSet();
        }

        @Override
        public boolean isCyclic() {
            return this.unifier.isCyclic();
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            return this.unifier.findRep(var);
        }

        @Override
        public boolean hasTerm(ITermVar var) {
            return this.unifier.hasTerm(var);
        }

        @Override
        public ITerm findTerm(ITerm term) {
            return this.unifier.findTerm(term);
        }

        @Override
        public ITerm findRecursive(ITerm term) {
            return this.unifier.findRecursive(term);
        }

        @Override
        public boolean isGround(ITerm term) {
            return this.unifier.isGround(term);
        }

        @Override
        public boolean isCyclic(ITerm term) {
            return this.unifier.isCyclic(term);
        }

        @Override
        public Set.Immutable<ITermVar> getVars(ITerm term) {
            return this.unifier.getVars(term);
        }

        @Override
        public TermSize size(ITerm term) {
            return this.unifier.size(term);
        }

        @Override
        public String toString(ITerm term) {
            return this.unifier.toString(term);
        }

        @Override
        public String toString(ITerm term, int n) {
            return this.unifier.toString(term, n);
        }

        @Override
        public Map.Immutable<ITermVar, ITerm> equalityMap() {
            return this.unifier.equalityMap();
        }

        @Override
        public Set.Immutable<Diseq> disequalities() {
            return this.unifier.disequalities();
        }

        @Override
        public Optional<IUnifier.Immutable> unify(ITerm term1, ITerm term2) throws OccursException {
            Optional<IUniDisunifier.Result<IUnifier.Immutable>> result = this.unifier.unify(term1, term2);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<? extends IUnifier.Immutable> unify(IUnifier other) throws OccursException {
            Optional<IUniDisunifier.Result<IUnifier.Immutable>> result = this.unifier.unify(other);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<IUnifier.Immutable> unify(IUniDisunifier other) throws OccursException {
            Optional<IUniDisunifier.Result<IUnifier.Immutable>> result = this.unifier.unify(other);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<IUnifier.Immutable> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities) throws OccursException {
            Optional<IUniDisunifier.Result<IUnifier.Immutable>> result = this.unifier.unify(equalities);
            return result.map(r -> {
                this.unifier = r.unifier();
                return (IUnifier.Immutable)r.result();
            });
        }

        @Override
        public Optional<Optional<Diseq>> disunify(Iterable<ITermVar> universal, ITerm term1, ITerm term2) {
            Optional<IUniDisunifier.Result<Optional<Diseq>>> result = this.unifier.disunify(universal, term1, term2);
            return result.map(ud -> {
                this.unifier = ud.unifier();
                return (Optional)ud.result();
            });
        }

        @Override
        public Optional<IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            return this.unifier.diff(term1, term2);
        }

        @Override
        public ISubstitution.Immutable retain(ITermVar var) {
            IUnifier.Result result = this.unifier.retain(var);
            this.unifier = result.unifier();
            return (ISubstitution.Immutable)result.result();
        }

        @Override
        public ISubstitution.Immutable retainAll(Iterable<ITermVar> vars) {
            IUnifier.Result result = this.unifier.retainAll((Iterable)vars);
            this.unifier = result.unifier();
            return (ISubstitution.Immutable)result.result();
        }

        @Override
        public ISubstitution.Immutable remove(ITermVar var) {
            IUnifier.Result result = this.unifier.remove(var);
            this.unifier = result.unifier();
            return (ISubstitution.Immutable)result.result();
        }

        @Override
        public ISubstitution.Immutable removeAll(Iterable<ITermVar> vars) {
            IUnifier.Result result = this.unifier.removeAll((Iterable)vars);
            this.unifier = result.unifier();
            return (ISubstitution.Immutable)result.result();
        }

        @Override
        public IUniDisunifier.Immutable freeze() {
            return this.unifier;
        }

        public String toString() {
            return this.unifier.toString();
        }
    }
}

