/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.ud;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.nabl2.util.CapsuleUtil;
import mb.nabl2.util.Tuple3;

public class Diseq {
    private final Set.Immutable<ITermVar> universals;
    private final IUnifier.Immutable diseqs;

    private Diseq(Set.Immutable<ITermVar> universals, IUnifier.Immutable diseqs) {
        this.universals = CapsuleUtil.toSet(universals);
        this.diseqs = diseqs;
    }

    public Set.Immutable<ITermVar> universals() {
        return this.universals;
    }

    public IUnifier.Immutable disequalities() {
        return this.diseqs;
    }

    public Set.Immutable<ITermVar> freeVarSet() {
        return Set.Immutable.subtract(this.diseqs.freeVarSet(), this.universals);
    }

    public boolean isEmpty() {
        return this.diseqs.isEmpty();
    }

    public Set.Immutable<ITermVar> varSet() {
        return Set.Immutable.subtract(this.diseqs.varSet(), this.universals);
    }

    public Tuple3<Set<ITermVar>, ITerm, ITerm> toTuple() {
        ImmutableList.Builder lefts = ImmutableList.builder();
        ImmutableList.Builder rights = ImmutableList.builder();
        this.diseqs.equalityMap().forEach((v, t) -> {
            lefts.add(v);
            rights.add(t);
        });
        return Tuple3.of(this.universals, TermBuild.B.newTuple((Iterable<? extends ITerm>)lefts.build()), TermBuild.B.newTuple((Iterable<? extends ITerm>)rights.build()));
    }

    public Diseq apply(ISubstitution.Immutable subst) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.universals);
        IUnifier.Transient newDiseqs = PersistentUnifier.Immutable.of(this.diseqs.isFinite()).melt();
        this.diseqs.equalityMap().forEach((v, t) -> {
            try {
                if (!newDiseqs.unify((ITerm)v, localSubst.apply((ITerm)t)).isPresent()) {
                    throw new IllegalArgumentException("Applying substitution failed unexpectedly.");
                }
            }
            catch (OccursException e) {
                throw new IllegalArgumentException("Applying substitution failed unexpectedly.");
            }
        });
        return new Diseq(this.universals, newDiseqs.freeze());
    }

    public Optional<Diseq> removeAll(Iterable<ITermVar> vars) {
        IUnifier.Immutable newDiseqs = this.diseqs.removeAll(vars).unifier();
        if (newDiseqs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Diseq(this.universals, newDiseqs));
    }

    public String toString() {
        return this.toTuple().apply((T1 us, T2 v, T3 t) -> {
            if (us.isEmpty()) {
                return v + " != " + t;
            }
            return "forall " + us + " . " + v + " != " + t;
        });
    }

    public static Diseq of(Iterable<ITermVar> universals, IUnifier.Immutable diseqs) {
        IUnifier.Immutable newDiseqs = diseqs.removeAll(universals).unifier();
        Set.Immutable newUniversals = Set.Immutable.intersect(CapsuleUtil.toSet(universals), newDiseqs.freeVarSet());
        return new Diseq((Set.Immutable<ITermVar>)newUniversals, newDiseqs);
    }
}

