/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification.ud;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.nabl2.terms.unification.ud.BaseUniDisunifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;

public abstract class PersistentUniDisunifier
extends BaseUniDisunifier
implements Serializable {
    private static final long serialVersionUID = 42L;

    protected static ITermVar findRep(ITermVar var, Map.Transient<ITermVar, ITermVar> reps) {
        ITermVar rep = (ITermVar)reps.get((Object)var);
        if (rep == null) {
            return var;
        }
        rep = PersistentUniDisunifier.findRep(rep, reps);
        reps.__put((Object)var, (Object)rep);
        return rep;
    }

    public static class Immutable
    extends PersistentUniDisunifier
    implements IUniDisunifier.Immutable,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final IUnifier.Immutable unifier;
        private final Set.Immutable<Diseq> disequalities;

        Immutable(boolean finite, Map.Immutable<ITermVar, ITermVar> reps, Map.Immutable<ITermVar, Integer> ranks, Map.Immutable<ITermVar, ITerm> terms, Set.Immutable<Diseq> disequalities) {
            this(new PersistentUnifier.Immutable(finite, reps, ranks, terms), disequalities);
        }

        Immutable(IUnifier.Immutable unifier, Set.Immutable<Diseq> disequalities) {
            this.unifier = unifier;
            this.disequalities = disequalities;
        }

        @Override
        public boolean isFinite() {
            return this.unifier.isFinite();
        }

        @Override
        protected IUnifier.Immutable unifier() {
            return this.unifier;
        }

        @Override
        public Set.Immutable<Diseq> disequalities() {
            return this.disequalities;
        }

        @Override
        public ITermVar findRep(ITermVar var) {
            return this.unifier.findRep(var);
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(ITerm left, ITerm right) throws OccursException {
            return this.unifier.unify(left, right).flatMap(r -> Immutable.disunifyAll(r.unifier(), this.disequalities).map(diseqs -> {
                Immutable ud = new Immutable(r.unifier(), (Set.Immutable<Diseq>)diseqs);
                return new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), ud);
            }));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> equalities) throws OccursException {
            return this.unifier.unify(equalities).flatMap(r -> Immutable.disunifyAll(r.unifier(), this.disequalities).map(diseqs -> {
                Immutable ud = new Immutable(r.unifier(), (Set.Immutable<Diseq>)diseqs);
                return new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), ud);
            }));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(IUnifier other) throws OccursException {
            return this.unifier.unify(other).flatMap(r -> Immutable.disunifyAll(r.unifier(), this.disequalities).map(diseqs -> {
                Immutable ud = new Immutable(r.unifier(), (Set.Immutable<Diseq>)diseqs);
                return new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), ud);
            }));
        }

        @Override
        public Optional<IUniDisunifier.Result<IUnifier.Immutable>> unify(IUniDisunifier other) throws OccursException {
            return this.unifier.unify(other.equalityMap().entrySet()).flatMap(r -> Immutable.disunifyAll(r.unifier(), this.disequalities).map(diseqs -> {
                Immutable ud = new Immutable(r.unifier(), (Set.Immutable<Diseq>)diseqs);
                return new BaseUniDisunifier.ImmutableResult<IUnifier.Immutable>((IUnifier.Immutable)r.result(), ud);
            }));
        }

        @Override
        public Optional<IUnifier.Immutable> diff(ITerm term1, ITerm term2) {
            try {
                return this.unify(term1, term2).map(IUniDisunifier.Result::result);
            }
            catch (OccursException e) {
                return Optional.empty();
            }
        }

        @Override
        public Optional<IUniDisunifier.Result<Optional<Diseq>>> disunify(Iterable<ITermVar> universals, ITerm left, ITerm right) {
            IUnifier.Transient diseqs = PersistentUnifier.Immutable.of(this.isFinite()).melt();
            try {
                if (!diseqs.unify(left, right).isPresent()) {
                    return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
                }
            }
            catch (OccursException e) {
                return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
            }
            Diseq diseq = Diseq.of(universals, diseqs.freeze());
            if (diseq.isEmpty()) {
                return Optional.empty();
            }
            Optional reducedDiseq = Immutable.disunify(this, diseq).orElse(null);
            if (reducedDiseq == null) {
                return Optional.empty();
            }
            if (!reducedDiseq.isPresent()) {
                return Optional.of(new BaseUniDisunifier.ImmutableResult(Optional.empty(), this));
            }
            Immutable newUnifier = new Immutable(this.unifier, (Set.Immutable<Diseq>)this.disequalities.__insert((Object)((Diseq)reducedDiseq.get())));
            return Optional.of(new BaseUniDisunifier.ImmutableResult<Optional>(reducedDiseq, newUnifier));
        }

        private static Optional<Set.Immutable<Diseq>> disunifyAll(IUnifier.Immutable unifier, Set.Immutable<Diseq> disequalities) {
            Set.Transient newDisequalities = Set.Transient.of();
            for (Diseq diseq : disequalities) {
                Optional reducedDiseq = Immutable.disunify(unifier, diseq).orElse(null);
                if (reducedDiseq == null) {
                    return Optional.empty();
                }
                if (!reducedDiseq.isPresent()) continue;
                newDisequalities.__insert((Object)((Diseq)reducedDiseq.get()));
            }
            return Optional.of(newDisequalities.freeze());
        }

        private static Optional<Optional<Diseq>> disunify(IUnifier.Immutable unifier, Diseq diseq) {
            Optional<? extends IUnifier.Result<? extends IUnifier.Immutable>> unifyResult;
            try {
                unifyResult = unifier.unify(diseq.disequalities());
            }
            catch (OccursException e) {
                return Optional.of(Optional.empty());
            }
            if (!unifyResult.isPresent()) {
                return Optional.of(Optional.empty());
            }
            IUnifier.Immutable diff = unifyResult.get().result();
            Set.Immutable universals = (Set.Immutable)diseq.universals().stream().flatMap(v -> unifier.getVars((ITerm)v).stream()).collect(CapsuleCollectors.toSet());
            Diseq newDiseq = Diseq.of((Iterable<ITermVar>)universals, diff);
            if (newDiseq.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Optional.of(newDiseq));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> retain(ITermVar var) {
            return this.retainAll((Iterable)Set.Immutable.of((Object)var));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> retainAll(Iterable<ITermVar> vars) {
            return this.removeAll((Iterable)Sets.difference(this.varSet(), (Set)ImmutableSet.copyOf(vars)));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> remove(ITermVar var) {
            return this.removeAll((Iterable)Set.Immutable.of((Object)var));
        }

        @Override
        public IUniDisunifier.Result<ISubstitution.Immutable> removeAll(Iterable<ITermVar> vars) {
            IUnifier.Result<ISubstitution.Immutable> r = this.unifier.removeAll(vars);
            Set.Transient newDisequalities = Set.Transient.of();
            this.disequalities.stream().flatMap(diseq -> Streams.stream(diseq.apply((ISubstitution.Immutable)r.result()).removeAll(vars))).forEach(arg_0 -> ((Set.Transient)newDisequalities).__insert(arg_0));
            Immutable ud = new Immutable(r.unifier(), (Set.Immutable<Diseq>)newDisequalities.freeze());
            return new BaseUniDisunifier.ImmutableResult<ISubstitution.Immutable>(r.result(), ud);
        }

        @Override
        public IUniDisunifier.Transient melt() {
            return new BaseUniDisunifier.Transient(this);
        }

        public static IUniDisunifier.Immutable of() {
            return Immutable.of(true);
        }

        public static IUniDisunifier.Immutable of(boolean finite) {
            return new Immutable(PersistentUnifier.Immutable.of(finite), (Set.Immutable<Diseq>)Set.Immutable.of());
        }
    }
}

