/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.Map;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;

public final class CapsuleUtil {
    private CapsuleUtil() {
    }

    public static <K, V> void updateValues(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val == null) continue;
            map.__put(key, val);
        }
    }

    public static <K, V> void updateValuesOrRemove(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val != null) {
                map.__put(key, val);
                continue;
            }
            map.__remove(key);
        }
    }

    public static <K, V> void updateKeys(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            if (newKey == null) continue;
            map.__remove(key);
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void updateKeysOrRemove(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            map.__remove(key);
            if (newKey == null) continue;
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void update(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            if (newVal == null) continue;
            set.__remove(val);
            set.__insert(newVal);
        }
    }

    public static <K, V> void updateOrRemove(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            set.__remove(val);
            if (newVal == null) continue;
            set.__insert(newVal);
        }
    }

    public static <V> Set.Immutable<V> toSet(Iterable<? extends V> values) {
        if (values instanceof Set.Immutable) {
            return (Set.Immutable)values;
        }
        Set.Transient set = Set.Transient.of();
        values.forEach(arg_0 -> ((Set.Transient)set).__insert(arg_0));
        return set.freeze();
    }

    public static <K, V> Map.Immutable<K, V> toMap(Map<? extends K, ? extends V> map) {
        if (map instanceof Map.Immutable) {
            return (Map.Immutable)map;
        }
        return Map.Immutable.of().__putAll(map);
    }

    public static <K, V> Map.Immutable<K, V> toMap(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Transient map = Map.Transient.of();
        entries.forEach(e -> {
            Object object = map.__put(e.getKey(), e.getValue());
        });
        return map.freeze();
    }
}

