/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class ConsList<E>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final E head;
    private final ConsList<E> tail;

    private ConsList(E head, ConsList<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private ConsList<E> current;
            {
                this.current = ConsList.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isNil();
            }

            @Override
            public E next() {
                if (this.current.isNil()) {
                    throw new NoSuchElementException();
                }
                Object next = this.current.head;
                this.current = this.current.tail;
                return next;
            }
        };
    }

    public ConsList<E> prepend(E head) {
        return new ConsList<E>(head, this);
    }

    public ConsList<E> prepend(ConsList<E> init) {
        LinkedList elems = Lists.newLinkedList();
        init.forEach(elems::push);
        ConsList list = this;
        while (!elems.isEmpty()) {
            list = list.prepend(elems.pop());
        }
        return list;
    }

    public ConsList<E> append(ConsList<E> tail) {
        return tail.prepend(this);
    }

    public ConsList<E> tail() {
        return this.isNil() ? this : this.tail;
    }

    private boolean isNil() {
        return this.head == null;
    }

    public static <E> ConsList<E> nil() {
        return new ConsList<Object>(null, null);
    }

    public static <E> ConsList<E> of(E e) {
        return new ConsList<E>(e, ConsList.nil());
    }

    @SafeVarargs
    public static <E> ConsList<E> of(E ... es) {
        return ConsList.of(Arrays.asList(es));
    }

    public static <E> ConsList<E> of(Iterable<E> es) {
        if (es instanceof ConsList) {
            return (ConsList)es;
        }
        ConsList<E> list = ConsList.nil();
        for (E e : es) {
            list = list.prepend(e);
        }
        return list;
    }

    public String toString() {
        return Streams.stream((Iterable)this).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }
}

