/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.Sets;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.util.collections.HashTrieInverseFunction;
import mb.nabl2.util.collections.IFunction;
import mb.nabl2.util.collections.IInverseFunction;

public abstract class HashTrieFunction<K, V>
implements IFunction<K, V> {
    protected HashTrieFunction() {
    }

    protected abstract Map<K, V> fwd();

    protected abstract SetMultimap<V, K> bwd();

    @Override
    public boolean containsKey(K key) {
        return this.fwd().containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.bwd().containsKey(value);
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.bwd().containsEntry(value, key);
    }

    @Override
    public Set<K> keySet() {
        return this.fwd().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fwd().entrySet();
    }

    @Override
    public Set<V> valueSet() {
        return this.bwd().keySet();
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.fwd().get(key));
    }

    public String toString() {
        return this.fwd().toString();
    }

    public static <K, V> IFunction<K, V> union(IFunction<K, V> fun1, IFunction<K, V> fun2) {
        return new Union(fun1, fun2);
    }

    public static class Immutable<K, V>
    extends HashTrieFunction<K, V>
    implements IFunction.Immutable<K, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Map.Immutable<K, V> fwd;
        private final SetMultimap.Immutable<V, K> bwd;

        Immutable(Map.Immutable<K, V> fwd, SetMultimap.Immutable<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected Map<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected SetMultimap<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public HashTrieInverseFunction.Immutable<V, K> inverse() {
            return new HashTrieInverseFunction.Immutable<V, K>(this.bwd, this.fwd);
        }

        @Override
        public Transient<K, V> melt() {
            return new Transient(this.fwd.asTransient(), this.bwd.asTransient());
        }

        public static <K, V> Immutable<K, V> of() {
            return new Immutable<K, V>(Map.Immutable.of(), SetMultimap.Immutable.of());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bwd.hashCode();
            result = 31 * result + this.fwd.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.bwd.equals(other.bwd)) {
                return false;
            }
            return this.fwd.equals(other.fwd);
        }
    }

    public static class Transient<K, V>
    extends HashTrieFunction<K, V>
    implements IFunction.Transient<K, V> {
        private final Map.Transient<K, V> fwd;
        private final SetMultimap.Transient<V, K> bwd;

        Transient(Map.Transient<K, V> fwd, SetMultimap.Transient<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected Map<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected SetMultimap<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public boolean put(K key, V value) {
            if (this.fwd.containsKey(key)) {
                if (value.equals(this.fwd.get(key))) {
                    return false;
                }
                throw new IllegalArgumentException("Already in domain.");
            }
            this.fwd.__put(key, value);
            this.bwd.__insert(value, key);
            return true;
        }

        @Override
        public boolean putAll(IFunction<K, V> other) {
            return other.stream().reduce(false, (change, kv) -> Boolean.logicalOr(change, this.put(kv._1(), kv._2())), Boolean::logicalOr);
        }

        @Override
        public boolean remove(K key) {
            Object value = this.fwd.__remove(key);
            if (value != null) {
                this.bwd.__remove(value, key);
                return true;
            }
            return false;
        }

        @Override
        public HashTrieInverseFunction.Transient<V, K> inverse() {
            return new HashTrieInverseFunction.Transient<V, K>(this.bwd, this.fwd);
        }

        @Override
        public Immutable<K, V> freeze() {
            return new Immutable(this.fwd.freeze(), this.bwd.freeze());
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(Map.Transient.of(), SetMultimap.Transient.of());
        }
    }

    private static class Union<K, V>
    implements IFunction<K, V> {
        private final IFunction<K, V> fun1;
        private final IFunction<K, V> fun2;

        private Union(IFunction<K, V> fun1, IFunction<K, V> fun2) {
            this.fun1 = fun1;
            this.fun2 = fun2;
        }

        @Override
        public IInverseFunction<V, K> inverse() {
            return HashTrieInverseFunction.union(this.fun1.inverse(), this.fun2.inverse());
        }

        @Override
        public boolean containsKey(K key) {
            return this.fun1.containsKey(key) || this.fun2.containsKey(key);
        }

        @Override
        public boolean containsEntry(K key, V value) {
            return this.fun1.containsEntry(key, value) || this.fun2.containsEntry(key, value);
        }

        @Override
        public boolean containsValue(V value) {
            return this.fun1.containsValue(value) || this.fun2.containsValue(value);
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.fun1.keySet(), this.fun2.keySet());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Sets.union(this.fun1.entrySet(), this.fun2.entrySet());
        }

        @Override
        public Set<V> valueSet() {
            return Sets.union(this.fun1.valueSet(), this.fun2.valueSet());
        }

        @Override
        public Optional<V> get(K key) {
            return this.fun1.get(key).map(Optional::of).orElseGet(() -> this.fun2.get(key));
        }
    }
}

