/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.Sets;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import mb.nabl2.util.collections.HashTrieFunction;
import mb.nabl2.util.collections.IFunction;
import mb.nabl2.util.collections.IInverseFunction;

public abstract class HashTrieInverseFunction<K, V>
implements IInverseFunction<K, V> {
    protected HashTrieInverseFunction() {
    }

    protected abstract SetMultimap<K, V> fwd();

    protected abstract Map<V, K> bwd();

    @Override
    public boolean containsKey(K key) {
        return this.fwd().containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.bwd().containsKey(value);
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.fwd().containsEntry(key, value);
    }

    @Override
    public Set<K> keySet() {
        return this.fwd().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fwd().entrySet();
    }

    @Override
    public Set<V> valueSet() {
        return this.bwd().keySet();
    }

    @Override
    public Set.Immutable<V> get(K key) {
        return this.fwd().get(key);
    }

    public String toString() {
        return this.fwd().toString();
    }

    public static <K, V> IInverseFunction<K, V> union(IInverseFunction<K, V> fun1, IInverseFunction<K, V> fun2) {
        return new Union(fun1, fun2);
    }

    public static class Immutable<K, V>
    extends HashTrieInverseFunction<K, V>
    implements IInverseFunction.Immutable<K, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final SetMultimap.Immutable<K, V> fwd;
        private final Map.Immutable<V, K> bwd;

        Immutable(SetMultimap.Immutable<K, V> fwd, Map.Immutable<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected SetMultimap<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected Map<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public HashTrieFunction.Immutable<V, K> inverse() {
            return new HashTrieFunction.Immutable<V, K>(this.bwd, this.fwd);
        }

        @Override
        public Transient<K, V> melt() {
            return new Transient(this.fwd.asTransient(), this.bwd.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fwd.hashCode();
            result = 31 * result + this.bwd.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.fwd.equals(other.fwd)) {
                return false;
            }
            return this.bwd.equals(other.bwd);
        }
    }

    public static class Transient<K, V>
    extends HashTrieInverseFunction<K, V>
    implements IInverseFunction.Transient<K, V> {
        private final SetMultimap.Transient<K, V> fwd;
        private final Map.Transient<V, K> bwd;

        Transient(SetMultimap.Transient<K, V> fwd, Map.Transient<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        protected SetMultimap<K, V> fwd() {
            return this.fwd;
        }

        @Override
        protected Map<V, K> bwd() {
            return this.bwd;
        }

        @Override
        public boolean put(K key, V value) {
            if (this.bwd.containsKey(value)) {
                throw new IllegalArgumentException();
            }
            if (this.fwd.__insert(key, value)) {
                this.bwd.__put(value, key);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(K key, V value) {
            if (this.fwd.__remove(key, value)) {
                this.bwd.__remove(value);
                return true;
            }
            return false;
        }

        @Override
        public HashTrieFunction.Transient<V, K> inverse() {
            return new HashTrieFunction.Transient<V, K>(this.bwd, this.fwd);
        }

        @Override
        public Immutable<K, V> freeze() {
            return new Immutable(this.fwd.freeze(), this.bwd.freeze());
        }
    }

    private static class Union<K, V>
    implements IInverseFunction<K, V> {
        private final IInverseFunction<K, V> fun1;
        private final IInverseFunction<K, V> fun2;

        private Union(IInverseFunction<K, V> fun1, IInverseFunction<K, V> fun2) {
            this.fun1 = fun1;
            this.fun2 = fun2;
        }

        @Override
        public IFunction<V, K> inverse() {
            return HashTrieFunction.union(this.fun1.inverse(), this.fun2.inverse());
        }

        @Override
        public boolean containsKey(K key) {
            return this.fun1.containsKey(key) || this.fun2.containsKey(key);
        }

        @Override
        public boolean containsEntry(K key, V value) {
            return this.fun1.containsEntry(key, value) || this.fun2.containsEntry(key, value);
        }

        @Override
        public boolean containsValue(V value) {
            return this.fun1.containsValue(value) || this.fun2.containsValue(value);
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.fun1.keySet(), this.fun2.keySet());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Sets.union(this.fun1.entrySet(), this.fun2.entrySet());
        }

        @Override
        public Set<V> valueSet() {
            return Sets.union(this.fun1.valueSet(), this.fun2.valueSet());
        }

        @Override
        public Set<V> get(K key) {
            return Sets.union(this.fun1.get(key), this.fun2.get(key));
        }
    }
}

