/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.Sets;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import mb.nabl2.util.Tuple2;
import mb.nabl2.util.collections.IRelation3;

public abstract class HashTrieRelation3<K, L, V>
implements IRelation3<K, L, V> {
    protected HashTrieRelation3() {
    }

    protected abstract SetMultimap<K, Tuple2<L, V>> fwdK();

    protected abstract SetMultimap<Tuple2<K, L>, V> fwdKL();

    protected abstract SetMultimap<V, Tuple2<L, K>> bwdV();

    @Override
    public boolean contains(K key) {
        return this.fwdK().containsKey(key);
    }

    @Override
    public boolean contains(K key, L label) {
        return this.fwdKL().containsKey(Tuple2.of(key, label));
    }

    @Override
    public boolean contains(K key, L label, V value) {
        return this.fwdK().containsEntry(key, Tuple2.of(label, value));
    }

    @Override
    public Set<K> keySet() {
        return this.fwdK().keySet();
    }

    @Override
    public Set<V> valueSet() {
        return this.bwdV().keySet();
    }

    @Override
    public Set<V> get(K key, L label) {
        return this.fwdKL().get(Tuple2.of(key, label));
    }

    @Override
    public Set<Tuple2<L, V>> get(K key) {
        return this.fwdK().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.fwdK().isEmpty();
    }

    public String toString() {
        return this.fwdK().toString();
    }

    public static <K, L, V> IRelation3<K, L, V> union(IRelation3<K, L, V> rel1, IRelation3<K, L, V> rel2) {
        return new Union(rel1, rel2);
    }

    public static class Immutable<K, L, V>
    extends HashTrieRelation3<K, L, V>
    implements IRelation3.Immutable<K, L, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final SetMultimap.Immutable<K, Tuple2<L, V>> fwdK;
        private final SetMultimap.Immutable<Tuple2<K, L>, V> fwdKL;
        private final SetMultimap.Immutable<V, Tuple2<L, K>> bwdV;
        private final SetMultimap.Immutable<Tuple2<V, L>, K> bwdVL;

        Immutable(SetMultimap.Immutable<K, Tuple2<L, V>> fwdK, SetMultimap.Immutable<Tuple2<K, L>, V> fwdKL, SetMultimap.Immutable<V, Tuple2<L, K>> bwdV, SetMultimap.Immutable<Tuple2<V, L>, K> bwdVL) {
            this.fwdK = fwdK;
            this.fwdKL = fwdKL;
            this.bwdV = bwdV;
            this.bwdVL = bwdVL;
        }

        @Override
        protected SetMultimap<K, Tuple2<L, V>> fwdK() {
            return this.fwdK;
        }

        @Override
        protected SetMultimap<Tuple2<K, L>, V> fwdKL() {
            return this.fwdKL;
        }

        @Override
        protected SetMultimap<V, Tuple2<L, K>> bwdV() {
            return this.bwdV;
        }

        @Override
        public IRelation3.Immutable<K, L, V> put(K key, L label, V value) {
            return new Immutable<K, L, V>(this.fwdK.__insert(key, Tuple2.of(label, value)), this.fwdKL.__insert(Tuple2.of(key, label), value), this.bwdV.__insert(value, Tuple2.of(label, key)), this.bwdVL.__insert(Tuple2.of(value, label), key));
        }

        @Override
        public IRelation3.Immutable<K, L, V> putAll(IRelation3<K, L, V> other) {
            IRelation3.Transient that = this.melt();
            that.putAll(other);
            return that.freeze();
        }

        @Override
        public IRelation3.Immutable<V, L, K> inverse() {
            return new Immutable<V, L, K>(this.bwdV, this.bwdVL, this.fwdK, this.fwdKL);
        }

        @Override
        public Transient<K, L, V> melt() {
            return new Transient(this.fwdK.asTransient(), this.fwdKL.asTransient(), this.bwdV.asTransient(), this.bwdVL.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fwdK.hashCode();
            result = 31 * result + this.fwdKL.hashCode();
            result = 31 * result + this.bwdV.hashCode();
            result = 31 * result + this.bwdVL.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.fwdK.equals(other.fwdK)) {
                return false;
            }
            if (!this.fwdKL.equals(other.fwdKL)) {
                return false;
            }
            if (!this.bwdV.equals(other.bwdV)) {
                return false;
            }
            return this.bwdVL.equals(other.bwdVL);
        }

        public static <K, L, V> Immutable<K, L, V> of() {
            return new Immutable<K, L, V>(SetMultimap.Immutable.of(), SetMultimap.Immutable.of(), SetMultimap.Immutable.of(), SetMultimap.Immutable.of());
        }
    }

    public static class Transient<K, L, V>
    extends HashTrieRelation3<K, L, V>
    implements IRelation3.Transient<K, L, V> {
        private final SetMultimap.Transient<K, Tuple2<L, V>> fwdK;
        private final SetMultimap.Transient<Tuple2<K, L>, V> fwdKL;
        private final SetMultimap.Transient<V, Tuple2<L, K>> bwdV;
        private final SetMultimap.Transient<Tuple2<V, L>, K> bwdVL;

        Transient(SetMultimap.Transient<K, Tuple2<L, V>> fwdK, SetMultimap.Transient<Tuple2<K, L>, V> fwdKL, SetMultimap.Transient<V, Tuple2<L, K>> bwdV, SetMultimap.Transient<Tuple2<V, L>, K> bwdVL) {
            this.fwdK = fwdK;
            this.fwdKL = fwdKL;
            this.bwdV = bwdV;
            this.bwdVL = bwdVL;
        }

        @Override
        protected SetMultimap<K, Tuple2<L, V>> fwdK() {
            return this.fwdK;
        }

        @Override
        protected SetMultimap<Tuple2<K, L>, V> fwdKL() {
            return this.fwdKL;
        }

        @Override
        protected SetMultimap<V, Tuple2<L, K>> bwdV() {
            return this.bwdV;
        }

        @Override
        public boolean put(K key, L label, V value) {
            if (this.fwdK.__insert(key, Tuple2.of(label, value))) {
                this.fwdKL.__insert(Tuple2.of(key, label), value);
                this.bwdV.__insert(value, Tuple2.of(label, key));
                this.bwdVL.__insert(Tuple2.of(value, label), key);
                return true;
            }
            return false;
        }

        @Override
        public boolean putAll(IRelation3<K, L, V> other) {
            return other.stream().reduce(false, (change, klv) -> Boolean.logicalOr(change, this.put(klv._1(), klv._2(), klv._3())), Boolean::logicalOr);
        }

        @Override
        public boolean remove(K key) {
            Set.Immutable entries = this.fwdK.get(key);
            if (!entries.isEmpty()) {
                this.fwdK.__remove(key);
                for (Tuple2 entry : entries) {
                    Object label = entry._1();
                    Object value = entry._2();
                    this.fwdKL.__remove(Tuple2.of(key, label));
                    this.bwdV.__remove(value);
                    this.bwdVL.__remove(Tuple2.of(value, label));
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(K key, L label) {
            Set.Immutable values = this.fwdKL.get(Tuple2.of(key, label));
            if (!values.isEmpty()) {
                this.fwdKL.__remove(Tuple2.of(key, label));
                for (Object value : values) {
                    this.bwdV.__remove(value, Tuple2.of(label, key));
                    this.bwdVL.__remove(Tuple2.of(value, label), key);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(K key, L label, V value) {
            if (this.fwdK.__remove(key, Tuple2.of(label, value))) {
                this.fwdKL.__remove(Tuple2.of(key, label), value);
                this.bwdV.__remove(value, Tuple2.of(label, key));
                this.bwdVL.__remove(Tuple2.of(value, label), key);
                return true;
            }
            return false;
        }

        @Override
        public IRelation3.Transient<V, L, K> inverse() {
            return new Transient<V, L, K>(this.bwdV, this.bwdVL, this.fwdK, this.fwdKL);
        }

        @Override
        public Immutable<K, L, V> freeze() {
            return new Immutable(this.fwdK.freeze(), this.fwdKL.freeze(), this.bwdV.freeze(), this.bwdVL.freeze());
        }

        public static <K, L, V> Transient<K, L, V> of() {
            return new Transient<K, L, V>(SetMultimap.Transient.of(), SetMultimap.Transient.of(), SetMultimap.Transient.of(), SetMultimap.Transient.of());
        }
    }

    private static class Union<K, L, V>
    implements IRelation3<K, L, V> {
        private final IRelation3<K, L, V> rel1;
        private final IRelation3<K, L, V> rel2;

        private Union(IRelation3<K, L, V> rel1, IRelation3<K, L, V> rel2) {
            this.rel1 = rel1;
            this.rel2 = rel2;
        }

        @Override
        public IRelation3<V, L, K> inverse() {
            return new Union<V, L, K>(this.rel1.inverse(), this.rel2.inverse());
        }

        @Override
        public boolean contains(K key) {
            return this.rel1.contains(key) || this.rel2.contains(key);
        }

        @Override
        public boolean contains(K key, L label) {
            return this.rel1.contains(key, label) || this.rel2.contains(key, label);
        }

        @Override
        public boolean contains(K key, L label, V value) {
            return this.rel1.contains(key, label, value) || this.rel2.contains(key, label, value);
        }

        @Override
        public boolean isEmpty() {
            return this.rel1.isEmpty() && this.rel2.isEmpty();
        }

        @Override
        public Set<? extends Map.Entry<L, V>> get(K key) {
            return Sets.union(this.rel1.get(key), this.rel2.get(key));
        }

        @Override
        public Set<V> get(K key, L label) {
            return Sets.union(this.rel1.get(key, label), this.rel2.get(key, label));
        }

        @Override
        public Set<K> keySet() {
            return Sets.union(this.rel1.keySet(), this.rel2.keySet());
        }

        @Override
        public Set<V> valueSet() {
            return Sets.union(this.rel1.valueSet(), this.rel2.valueSet());
        }
    }
}

