/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.util.collections.MultiSet;
import org.metaborg.util.functions.Function1;

public class IndexedBag<V, I> {
    private final MultiSet.Transient<V> values = MultiSet.Transient.of();
    private final Multimap<I, Entry> entries = HashMultimap.create();
    private final RemovalPolicy removalPolicy;

    public IndexedBag(RemovalPolicy removalPolicy) {
        this.removalPolicy = removalPolicy;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean contains(V value) {
        return this.values.contains(value);
    }

    public Collection<V> values() {
        return this.entries.values().stream().map(e -> e.value).collect(Collectors.toList());
    }

    public boolean add(V value, Iterable<? extends I> indices) {
        this.values.add(value);
        Entry entry = new Entry(value);
        for (I index : indices) {
            this.entries.put(index, (Object)entry);
            entry.indices.add(index);
        }
        return this.tryRemove(entry);
    }

    public Collection<V> reindex(I index, Function1<I, ? extends Iterable<? extends I>> normalize) {
        Collection entries = this.entries.removeAll(index).stream().collect(Collectors.toList());
        ImmutableSet newIndices = ImmutableSet.copyOf(normalize.apply(index));
        if (this.removalPolicy.equals((Object)RemovalPolicy.ANY) && !newIndices.contains(index)) {
            entries.forEach(e -> {
                e.indices.forEach(i -> {
                    boolean bl = this.entries.remove(i, e);
                });
                e.indices.clear();
            });
        } else {
            entries.forEach(e -> {
                boolean bl = e.indices.remove(index);
            });
            for (Object newIndex : newIndices) {
                for (Entry entry : entries) {
                    this.entries.put(newIndex, (Object)entry);
                    entry.indices.add(newIndex);
                }
            }
        }
        return entries.stream().filter(e -> this.tryRemove((Entry)e)).map(v -> v.value).collect(Collectors.toList());
    }

    private boolean tryRemove(Entry entry) {
        if (entry.indices.isEmpty()) {
            this.values.remove(entry.value);
            return true;
        }
        return false;
    }

    private class Entry {
        public final V value;
        public final Set<I> indices;

        public Entry(V value) {
            this.value = value;
            this.indices = Sets.newHashSet();
        }
    }

    public static enum RemovalPolicy {
        ANY,
        ALL;

    }
}

