/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.util.collections.MultiSetMap;
import org.metaborg.util.functions.Function1;

public class IndexedBagMultimap<K, V, I> {
    private final MultiSetMap.Transient<K, V> values = MultiSetMap.Transient.of();
    private final Multimap<I, Entry> entries = HashMultimap.create();
    private final RemovalPolicy removalPolicy;

    public IndexedBagMultimap(RemovalPolicy removalPolicy) {
        this.removalPolicy = removalPolicy;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.values.containsKey(key);
    }

    public boolean contains(K key, V value) {
        return this.values.contains(key, value);
    }

    public Collection<V> values() {
        return this.entries.values().stream().map(e -> e.getValue()).collect(Collectors.toList());
    }

    public Collection<Entry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public Collection<I> indices() {
        return this.entries.keySet();
    }

    public boolean put(K key, V value, Iterable<? extends I> indices) {
        this.values.put(key, value);
        Entry entry = new Entry(key, value);
        for (I index : indices) {
            this.entries.put(index, (Object)entry);
            entry.indices.add(index);
        }
        return this.tryRemove(entry);
    }

    public Collection<Entry> reindex(I index, Function1<I, ? extends Iterable<? extends I>> normalize) {
        Collection entries = this.entries.removeAll(index).stream().collect(Collectors.toList());
        ImmutableSet newIndices = ImmutableSet.copyOf(normalize.apply(index));
        if (this.removalPolicy.equals((Object)RemovalPolicy.ANY) && !newIndices.contains(index)) {
            entries.forEach(e -> {
                e.indices.forEach(i -> {
                    boolean bl = this.entries.remove(i, e);
                });
                e.indices.clear();
            });
        } else {
            entries.forEach(e -> {
                boolean bl = e.indices.remove(index);
            });
            for (Object newIndex : newIndices) {
                for (Entry entry : entries) {
                    this.entries.put(newIndex, (Object)entry);
                    entry.indices.add(newIndex);
                }
            }
        }
        return entries.stream().filter(e -> this.tryRemove((Entry)e)).collect(Collectors.toList());
    }

    public Collection<Entry> reindexAll(Function1<I, ? extends Iterable<? extends I>> normalize) {
        return (Collection)Lists.newArrayList((Iterable)this.entries.keySet()).stream().flatMap(i -> this.reindex(i, normalize).stream()).collect(ImmutableList.toImmutableList());
    }

    private boolean tryRemove(Entry entry) {
        if (entry.indices.isEmpty()) {
            this.values.remove(entry.getKey(), entry.getValue());
            return true;
        }
        return false;
    }

    public final class Entry
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;
        public final Set<I> indices;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
            this.indices = Sets.newHashSet();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public Set<I> getIndices() {
            return this.indices;
        }
    }

    public static enum RemovalPolicy {
        ANY,
        ALL;

    }
}

