/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaborg.util.functions.Action2;

public abstract class MultiSet<E> {
    protected abstract Map<E, Integer> elements();

    public boolean isEmpty() {
        return this.elements().isEmpty();
    }

    public int size() {
        return this.elements().values().stream().mapToInt(i -> i).sum();
    }

    public int count(E e) {
        return (Integer)this.elements().getOrDefault(e, (Object)0);
    }

    public boolean contains(E e) {
        return this.elements().containsKey(e);
    }

    public Set<E> elementSet() {
        return this.elements().keySet();
    }

    public void forEach(Action2<E, Integer> f) {
        this.elements().entrySet().forEach((? super T e) -> f.apply(e.getKey(), (Integer)e.getValue()));
    }

    public String toString() {
        return this.elements().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class Immutable<E>
    extends MultiSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map.Immutable<E, Integer> elements;

        private Immutable(Map.Immutable<E, Integer> elements) {
            this.elements = elements;
        }

        @Override
        protected Map<E, Integer> elements() {
            return this.elements;
        }

        public Immutable<E> add(E e) {
            return this.add(e, 1);
        }

        public Immutable<E> add(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int c = (Integer)this.elements.getOrDefault(e, (Object)0) + n;
            if (c > 0) {
                return new Immutable<E>(this.elements.__put(e, (Object)c));
            }
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> addAll(Iterable<E> es) {
            Immutable<E> result = this;
            for (E e : es) {
                result = result.add(e);
            }
            return result;
        }

        public Immutable<E> remove(E e) {
            return this.remove(e, 1);
        }

        public Immutable<E> remove(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int c = Math.max(0, (Integer)this.elements.getOrDefault(e, (Object)0) - n);
            if (c > 0) {
                return new Immutable<E>(this.elements.__put(e, (Object)c));
            }
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> removeAll(E e) {
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Transient<E> melt() {
            return new Transient(this.elements.asTransient());
        }

        public static <E> Immutable<E> of() {
            return new Immutable<E>(Map.Immutable.of());
        }
    }

    public static class Transient<E>
    extends MultiSet<E> {
        private Map.Transient<E, Integer> elements;

        private Transient(Map.Transient<E, Integer> elements) {
            this.elements = elements;
        }

        @Override
        protected Map<E, Integer> elements() {
            return this.elements;
        }

        public int add(E e) {
            return this.add(e, 1);
        }

        public int add(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int c = (Integer)this.elements.getOrDefault(e, (Object)0) + n;
            if (c > 0) {
                this.elements.__put(e, (Object)c);
            } else {
                this.elements.__remove(e);
            }
            return c;
        }

        public void addAll(Iterable<E> es) {
            for (E e : es) {
                this.add(e);
            }
        }

        public int remove(E e) {
            return this.remove(e, 1);
        }

        public void removeAll(Iterable<E> es) {
            for (E e : es) {
                this.remove(e);
            }
        }

        public int remove(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int c = Math.max(0, (Integer)this.elements.getOrDefault(e, (Object)0) - n);
            if (c > 0) {
                this.elements.__put(e, (Object)c);
            } else {
                this.elements.__remove(e);
            }
            return c;
        }

        public int removeAll(E e) {
            int c = (Integer)this.elements.getOrDefault(e, (Object)0);
            this.elements.__remove(e);
            return c;
        }

        public Immutable<E> freeze() {
            return new Immutable(this.elements.freeze());
        }

        public static <E> Transient<E> of() {
            return new Transient<E>(Map.Transient.of());
        }
    }
}

