/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import io.usethesource.capsule.Map;
import mb.nabl2.util.collections.MultiSet;

public abstract class MultiSetMap<K, V> {
    protected abstract Map<K, MultiSet.Immutable<V>> entries();

    public boolean isEmpty() {
        return this.entries().isEmpty();
    }

    public boolean containsKey(K key) {
        return this.entries().containsKey(key);
    }

    public boolean contains(K key, V value) {
        return ((MultiSet.Immutable)this.entries().getOrDefault(key, MultiSet.Immutable.of())).contains(value);
    }

    public int count(K key, V value) {
        return ((MultiSet.Immutable)this.entries().getOrDefault(key, MultiSet.Immutable.of())).count(value);
    }

    public static class Transient<K, V>
    extends MultiSetMap<K, V> {
        private final Map.Transient<K, MultiSet.Immutable<V>> entries;

        private Transient(Map.Transient<K, MultiSet.Immutable<V>> entries) {
            this.entries = entries;
        }

        @Override
        public Map.Transient<K, MultiSet.Immutable<V>> entries() {
            return this.entries;
        }

        public void put(K key, V value) {
            MultiSet.Transient<V> values = ((MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of())).melt();
            values.add(value);
            this.entries.__put(key, values.freeze());
        }

        public MultiSet.Immutable<V> removeKey(K key) {
            if (this.entries.containsKey(key)) {
                return (MultiSet.Immutable)this.entries.__remove(key);
            }
            return MultiSet.Immutable.of();
        }

        public int remove(K key, V value) {
            MultiSet.Transient<V> values = ((MultiSet.Immutable)this.entries.getOrDefault(key, MultiSet.Immutable.of())).melt();
            int n = values.remove(value);
            if (values.isEmpty()) {
                this.entries.__remove(key);
            } else {
                this.entries.__put(key, values.freeze());
            }
            return n;
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(Map.Transient.of());
        }
    }
}

