/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import mb.pie.api.Function;
import mb.pie.api.Logger;
import mb.pie.api.STask;
import mb.pie.api.STaskDef;
import mb.pie.api.Supplier;
import mb.pie.api.Task;
import mb.pie.api.TaskDef;
import mb.pie.api.exec.CancelToken;
import mb.pie.api.stamp.OutputStamper;
import mb.pie.api.stamp.ResourceStamper;
import mb.resource.ReadableResource;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceService;
import mb.resource.WritableResource;
import mb.resource.fs.FSPath;
import mb.resource.fs.FSResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.ResourcePath;

public interface ExecContext {
    public <I extends Serializable, O extends Serializable> O require(TaskDef<I, O> var1, I var2);

    public <I extends Serializable, O extends Serializable> O require(TaskDef<I, O> var1, I var2, OutputStamper var3);

    public <O extends Serializable> O require(Task<O> var1);

    public <O extends Serializable> O require(Task<O> var1, OutputStamper var2);

    public <I extends Serializable, O extends Serializable> O require(STaskDef<I, O> var1, I var2);

    public <I extends Serializable, O extends Serializable> O require(STaskDef<I, O> var1, I var2, OutputStamper var3);

    public <O extends Serializable> O require(STask<O> var1);

    public <O extends Serializable> O require(STask<O> var1, OutputStamper var2);

    public <O extends Serializable> O require(Supplier<O> var1) throws IOException;

    public <I extends Serializable, O extends Serializable> O require(Function<I, O> var1, I var2);

    public OutputStamper getDefaultOutputStamper();

    public ResourceService getResourceService();

    public <R extends Resource> void require(R var1, ResourceStamper<R> var2) throws IOException;

    public <R extends Resource> void provide(R var1, ResourceStamper<R> var2) throws IOException;

    default public Resource getResource(ResourceKey key) {
        return this.getResourceService().getResource(key);
    }

    default public ReadableResource getReadableResource(ResourceKey key) {
        return this.getResourceService().getReadableResource(key);
    }

    default public WritableResource getWritableResource(ResourceKey key) {
        return this.getResourceService().getWritableResource(key);
    }

    default public HierarchicalResource getHierarchicalResource(ResourcePath path) {
        return this.getResourceService().getHierarchicalResource(path);
    }

    default public ReadableResource require(ResourceKey key, ResourceStamper<ReadableResource> stamper) throws IOException {
        ReadableResource resource = this.getReadableResource(key);
        this.require(resource, stamper);
        return resource;
    }

    default public HierarchicalResource require(ResourcePath path, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        HierarchicalResource resource = this.getHierarchicalResource(path);
        this.require(resource, stamper);
        return resource;
    }

    default public void require(ReadableResource resource) throws IOException {
        this.require(resource, this.getDefaultRequireReadableResourceStamper());
    }

    public ResourceStamper<ReadableResource> getDefaultRequireReadableResourceStamper();

    default public void provide(ReadableResource resource) throws IOException {
        this.provide(resource, this.getDefaultProvideReadableResourceStamper());
    }

    public ResourceStamper<ReadableResource> getDefaultProvideReadableResourceStamper();

    default public FSResource require(FSPath path) throws IOException {
        FSResource resource = new FSResource(path);
        this.require(resource, this.getDefaultRequireHierarchicalResourceStamper());
        return resource;
    }

    default public FSResource require(FSPath path, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        FSResource resource = new FSResource(path);
        this.require(resource, stamper);
        return resource;
    }

    default public void require(HierarchicalResource resource) throws IOException {
        this.require(resource, this.getDefaultRequireHierarchicalResourceStamper());
    }

    default public FSResource require(Path path) throws IOException {
        FSResource resource = new FSResource(path);
        this.require(resource, this.getDefaultRequireHierarchicalResourceStamper());
        return resource;
    }

    default public FSResource require(Path path, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        FSResource resource = new FSResource(path);
        this.require(resource, stamper);
        return resource;
    }

    default public FSResource require(File file) throws IOException {
        FSResource resource = new FSResource(file);
        this.require(resource, this.getDefaultRequireHierarchicalResourceStamper());
        return resource;
    }

    default public FSResource require(File file, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        FSResource resource = new FSResource(file);
        this.require(resource, stamper);
        return resource;
    }

    public ResourceStamper<HierarchicalResource> getDefaultRequireHierarchicalResourceStamper();

    default public void provide(FSPath path) throws IOException {
        this.provide(new FSResource(path), this.getDefaultProvideHierarchicalResourceStamper());
    }

    default public void provide(FSPath path, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        this.provide(new FSResource(path), stamper);
    }

    default public void provide(HierarchicalResource resource) throws IOException {
        this.provide(resource, this.getDefaultProvideHierarchicalResourceStamper());
    }

    default public void provide(Path path) throws IOException {
        this.provide(new FSResource(path), this.getDefaultProvideHierarchicalResourceStamper());
    }

    default public void provide(Path path, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        this.provide(new FSResource(path), stamper);
    }

    default public void provide(File file) throws IOException {
        this.provide(new FSResource(file), this.getDefaultProvideHierarchicalResourceStamper());
    }

    default public void provide(File file, ResourceStamper<HierarchicalResource> stamper) throws IOException {
        this.provide(new FSResource(file), stamper);
    }

    public ResourceStamper<HierarchicalResource> getDefaultProvideHierarchicalResourceStamper();

    public CancelToken cancelToken();

    public Logger logger();
}

