/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FunctionBasedSupplier<T extends Serializable, R extends @Nullable Serializable>
implements Supplier<R> {
    private final Function<T, R> function;
    private final T input;

    public FunctionBasedSupplier(Function<T, R> function, T input) {
        this.function = function;
        this.input = input;
    }

    @Override
    public R get(ExecContext context) {
        return this.function.apply(context, this.input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionBasedSupplier mappedFunctionInput = (FunctionBasedSupplier)o;
        if (!this.function.equals(mappedFunctionInput.function)) {
            return false;
        }
        return this.input.equals(mappedFunctionInput.input);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.input.hashCode();
        return result;
    }

    public String toString() {
        return "FunctionBasedSupplier(" + this.function + ", " + this.input + ")";
    }
}

