/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.IOException;
import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappedSupplier<T extends Serializable, R extends @Nullable Serializable>
implements Supplier<R> {
    private final Supplier<T> supplier;
    private final Function<? super T, ? extends R> func;

    public MappedSupplier(Supplier<T> supplier, Function<? super T, ? extends R> func) {
        this.supplier = supplier;
        this.func = func;
    }

    @Override
    public R get(ExecContext context) throws IOException {
        return this.func.apply(context, this.supplier.get(context));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedSupplier mappedSupplier = (MappedSupplier)o;
        if (!this.supplier.equals(mappedSupplier.supplier)) {
            return false;
        }
        return this.func.equals(mappedSupplier.func);
    }

    public int hashCode() {
        int result = this.supplier.hashCode();
        result = 31 * result + this.func.hashCode();
        return result;
    }

    public String toString() {
        return "MappedSupplier(" + this.supplier + ", " + this.func + ")";
    }
}

