/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.StoreReadTxn;
import mb.pie.api.StoreWriteTxn;
import mb.pie.api.TaskKey;
import mb.pie.api.TaskRequireDep;

public enum Observability implements Serializable
{
    ExplicitObserved,
    ImplicitObserved,
    Unobserved;


    public boolean isObserved() {
        return this == ExplicitObserved || this == ImplicitObserved;
    }

    public boolean isUnobserved() {
        return this == Unobserved;
    }

    public static void explicitUnobserve(StoreWriteTxn txn, TaskKey key) {
        if (Observability.isObservedByCaller(txn, key)) {
            txn.setTaskObservability(key, ImplicitObserved);
        } else {
            txn.setTaskObservability(key, Unobserved);
            for (TaskRequireDep taskRequire : txn.taskRequires(key)) {
                Observability.implicitUnobserve(txn, taskRequire.callee);
            }
        }
    }

    public static void implicitUnobserve(StoreWriteTxn txn, TaskKey key) {
        Observability observability = txn.taskObservability(key);
        if (observability != ImplicitObserved) {
            return;
        }
        if (Observability.isObservedByCaller(txn, key)) {
            return;
        }
        txn.setTaskObservability(key, Unobserved);
        for (TaskRequireDep taskRequire : txn.taskRequires(key)) {
            Observability.implicitUnobserve(txn, taskRequire.callee);
        }
    }

    private static boolean isObservedByCaller(StoreReadTxn txn, TaskKey key) {
        return txn.callersOf(key).stream().map(txn::taskObservability).anyMatch(Observability::isObserved);
    }
}

