/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.STask;
import mb.pie.api.Supplier;
import mb.pie.api.TaskDef;
import mb.pie.api.TaskKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Task<O extends @Nullable Serializable> {
    public final TaskDef<Serializable, O> taskDef;
    public final Serializable input;

    public <I extends Serializable> Task(TaskDef<I, O> taskDef, Serializable input) {
        TaskDef<I, O> inputErasedTaskDef = taskDef;
        this.taskDef = inputErasedTaskDef;
        this.input = input;
    }

    public Supplier<O> toSupplier() {
        return new STask<O>(this.taskDef, this.input);
    }

    public String getId() {
        return this.taskDef.getId();
    }

    public TaskKey key() {
        Serializable key = this.taskDef.key(this.input);
        return new TaskKey(this.taskDef.getId(), key);
    }

    public O exec(ExecContext ctx) throws Exception {
        return this.taskDef.exec(ctx, this.input);
    }

    public String desc(int maxLength) {
        return this.taskDef.desc(this.input, maxLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (!this.taskDef.getId().equals(task.taskDef.getId())) {
            return false;
        }
        return this.input.equals(task.input);
    }

    public int hashCode() {
        int result = this.taskDef.getId().hashCode();
        result = 31 * result + this.input.hashCode();
        return result;
    }

    public String toString() {
        return this.desc(100);
    }
}

