/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.pie.api.Observability;
import mb.pie.api.ResourceProvideDep;
import mb.pie.api.ResourceRequireDep;
import mb.pie.api.TaskRequireDep;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TaskData {
    public final Serializable input;
    public final @Nullable Serializable output;
    public final Observability taskObservability;
    public final ArrayList<TaskRequireDep> taskRequires;
    public final ArrayList<ResourceRequireDep> resourceRequires;
    public final ArrayList<ResourceProvideDep> resourceProvides;

    public TaskData(Serializable input, @Nullable Serializable output, Observability taskObservability, ArrayList<TaskRequireDep> taskRequires, ArrayList<ResourceRequireDep> resourceRequires, ArrayList<ResourceProvideDep> resourceProvides) {
        this.input = input;
        this.output = output;
        this.taskObservability = taskObservability;
        this.taskRequires = taskRequires;
        this.resourceRequires = resourceRequires;
        this.resourceProvides = resourceProvides;
    }

    public TaskData withTaskObservability(Observability taskObservability) {
        return new TaskData(this.input, this.output, taskObservability, this.taskRequires, this.resourceRequires, this.resourceProvides);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskData taskData = (TaskData)o;
        if (!this.input.equals(taskData.input)) {
            return false;
        }
        if (!Objects.equals(this.output, taskData.output)) {
            return false;
        }
        if (!this.taskObservability.equals(taskData.taskObservability)) {
            return false;
        }
        if (!this.taskRequires.equals(taskData.taskRequires)) {
            return false;
        }
        if (!this.resourceRequires.equals(taskData.resourceRequires)) {
            return false;
        }
        return this.resourceProvides.equals(taskData.resourceProvides);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
        result = 31 * result + this.taskObservability.hashCode();
        result = 31 * result + this.taskRequires.hashCode();
        result = 31 * result + this.resourceRequires.hashCode();
        result = 31 * result + this.resourceProvides.hashCode();
        return result;
    }

    public String toString() {
        return "TaskData(  input             = " + this.input + ", output            = " + this.output + ", taskObservability = " + this.taskObservability + ", taskRequires      = " + this.taskRequires + ", resourceRequires  = " + this.resourceRequires + ", resourceProvides  = " + this.resourceProvides + ')';
    }
}

