/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.STask;
import mb.pie.api.STaskDef;
import mb.pie.api.StringUtil;
import mb.pie.api.Supplier;
import mb.pie.api.Task;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TaskDef<I extends Serializable, O extends @Nullable Serializable> {
    public String getId();

    public O exec(ExecContext var1, I var2) throws Exception;

    default public Serializable key(I input) {
        return input;
    }

    default public String desc(I input, int maxLength) {
        return this.getId() + '(' + StringUtil.toShortString(input.toString(), maxLength) + ')';
    }

    default public Task<O> createTask(I input) {
        return new Task(this, (Serializable)input);
    }

    default public Supplier<O> createSupplier(I input) {
        return new STask(this, input);
    }

    default public Function<I, O> createFunction() {
        return new STaskDef(this);
    }
}

